/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.mods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BucketHandler {
    public static final HashMap<Block, BucketHandler> blockToHandler = new HashMap();
    public static final HashMap<Fluid, BucketHandler> fluidToHandler = new HashMap();
    public static final HashMap<Class<? extends Entity>, BucketHandler> entityToHandler = new HashMap();
    public static final List<BucketHandler> bucketHandlers = new ArrayList<BucketHandler>();

    public static void addBucketHandler(BucketHandler handler) {
        if (!bucketHandlers.contains(handler)) {
            bucketHandlers.add(handler);
        }
    }

    public static void addBucketHandler(Block block, BucketHandler handler) {
        BucketHandler.addBucketHandler(handler);
        blockToHandler.put(block, handler);
    }

    public static void addBucketHandler(Fluid fluid, BucketHandler handler) {
        BucketHandler.addBucketHandler(handler);
        fluidToHandler.put(fluid, handler);
    }

    public ItemStack emptyBucketClickBlock(EntityPlayer player, ItemStack itemstack, World world, BlockPos pos) {
        return itemstack;
    }

    public ItemStack filledBucketClickBlock(EntityPlayer player, ItemStack itemstack, World world, BlockPos pos) {
        return itemstack;
    }

    public ItemStack placeFluidClickBlock(EntityPlayer player, ItemStack itemstack, World world, BlockPos pos) {
        return itemstack;
    }

    public boolean onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        return false;
    }

    public boolean onBucketLeaked(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return false;
    }

    public boolean rightClickEntity(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        return false;
    }

    public void getSubItems(Item item, List list) {
    }
}

