/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.fluid;

import com.builtbroken.mc.fluids.FluidModule;
import com.builtbroken.mc.fluids.fluid.FluidHelper;
import com.builtbroken.mc.fluids.fluid.FluidVE;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;

public enum Fluids {
    MILK("milk", new Color(235, 231, 210, 255)),
    FUEL("fuel", new Color(110, 109, 19, 255)),
    OIL("oil", new Color(27, 27, 27, 255));

    public final String name;
    public final Color color;
    public final int colorInt;
    public boolean generate = false;
    public Fluid fluid;
    public Block block;

    private Fluids(String name, Color color) {
        this.name = name;
        this.color = color;
        this.colorInt = color != null ? color.getRGB() : -1;
    }

    public static void load(Configuration configuration) {
        FluidModule.logger.info("Generating fluids");
        for (Fluids data : Fluids.values()) {
            if (!data.generate && !configuration.getBoolean(data.name, "GenerateFluid", true, "Set to true to load the fluid into the game. Mods can override this behavior if they depend on the fluid.")) continue;
            FluidModule.logger.info("\tGenerating '" + data.name);
            data.fluid = FluidHelper.createOrGetFluid(data.name, "fluid");
            if (data.fluid == null) continue;
            if (data.fluid instanceof FluidVE) {
                ((FluidVE)data.fluid).setColor(data.colorInt);
            }
            FluidModule.logger.info("\t\t= " + data.fluid);
        }
    }
}

