/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.fluid;

import com.builtbroken.mc.fluids.fluid.BlockSimpleFluid;
import com.builtbroken.mc.fluids.fluid.FluidVE;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidHelper {
    public static List<Fluid> generatedFluids = new ArrayList<Fluid>();
    public static List<BlockSimpleFluid> generatedFluidBlocks = new ArrayList<BlockSimpleFluid>();

    public static Fluid createOrGetFluid(String name, String icon) {
        return FluidHelper.createOrGetFluid("vefluids", name, icon);
    }

    public static Fluid createOrGetFluid(String domain, String name, String icon) {
        Fluid fluid;
        if (FluidRegistry.getFluid((String)name) == null) {
            fluid = new FluidVE(domain, name, icon);
            if (!FluidRegistry.registerFluid((Fluid)fluid)) {
                throw new RuntimeException("Failed to register fluid[" + name + "] even though one is not registered");
            }
            generatedFluids.add(fluid);
        } else {
            fluid = FluidRegistry.getFluid((String)name);
        }
        return fluid;
    }

    public static void createBlockForFluidIfMissing(Fluid fluid, RegistryEvent.Register<Block> event) {
        if (fluid.getBlock() == null) {
            String name = fluid.getName();
            BlockSimpleFluid block = new BlockSimpleFluid(fluid, name);
            block.setRegistryName("veBlock" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length()));
            generatedFluidBlocks.add(block);
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }
}

