/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.client;

import com.builtbroken.mc.fluids.FluidModule;
import com.builtbroken.mc.fluids.bucket.BucketMaterial;
import com.builtbroken.mc.fluids.bucket.BucketMaterialHandler;
import com.builtbroken.mc.fluids.bucket.ItemFluidBucket;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class ModelFluidBucket
implements IModel {
    public static final ResourceLocation default_fluid_texture = new ResourceLocation("vefluids", "items/bucket.fluid2");
    public static final ResourceLocation default_bucket_texture = new ResourceLocation("vefluids", "items/bucket.missing");
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelFluidBucket();
    protected final ResourceLocation baseLocation;
    protected final ResourceLocation liquidLocation;
    protected final Fluid fluid;
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);

    public ModelFluidBucket() {
        this(null, null, null);
    }

    public ModelFluidBucket(ResourceLocation baseLocation, ResourceLocation liquidLocation, Fluid fluid) {
        this.baseLocation = baseLocation != null ? baseLocation : default_bucket_texture;
        this.liquidLocation = liquidLocation != null ? liquidLocation : default_fluid_texture;
        this.fluid = fluid;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)default_fluid_texture);
        builder.add((Object)default_bucket_texture);
        for (BucketMaterial material : BucketMaterialHandler.getMaterials()) {
            if (material.getBucketResourceLocation() != null) {
                builder.add((Object)material.getBucketResourceLocation());
            }
            if (material.getFluidResourceLocation() == null) continue;
            builder.add((Object)material.getFluidResourceLocation());
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, java.util.function.Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableList.Builder builder;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        if (transformMap.isEmpty()) {
            TRSRTransformation thirdperson = ModelFluidBucket.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
            TRSRTransformation firstperson = ModelFluidBucket.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
            builder = ImmutableMap.builder();
            builder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelFluidBucket.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            builder.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ModelFluidBucket.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
            builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelFluidBucket.leftify(thirdperson));
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstperson);
            builder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelFluidBucket.leftify(firstperson));
            transformMap = PerspectiveMapWrapper.getTransforms((IModelState)new SimpleModelState(builder.build()));
        }
        if (this.fluid != null && this.fluid.isGaseous()) {
            state = new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite fluidSprite = null;
        builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            IBakedModel model = new ItemLayerModel(ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            TextureAtlasSprite liquid = bakedTextureGetter.apply(this.liquidLocation);
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)this.fluid.getColor()));
            builder.addAll((Iterable)ItemTextureQuadConverter.convertTexture((VertexFormat)format, (TRSRTransformation)transform, (TextureAtlasSprite)liquid, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)this.fluid.getColor()));
        }
        return new BakedFluidBucket(this, (ImmutableList<BakedQuad>)builder.build(), fluidSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    private static TRSRTransformation leftify(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        String materialName;
        BucketMaterial material;
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        if ((material = BucketMaterialHandler.getMaterial(materialName = (String)customData.get((Object)"material"))) == null) {
            material = FluidModule.materialIron;
        }
        return new ModelFluidBucket(material.getBucketResourceLocation(), material.getFluidResourceLocation(), fluid);
    }

    private static final class BakedFluidBucket
    implements IBakedModel {
        private final ModelFluidBucket parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;

        public BakedFluidBucket(ModelFluidBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        public ItemOverrideList func_188617_f() {
            return BakedDynBucketOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends ItemOverrideList {
        public static final BakedDynBucketOverrideHandler INSTANCE = new BakedDynBucketOverrideHandler();

        private BakedDynBucketOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            BakedFluidBucket model = (BakedFluidBucket)originalModel;
            String material = "iron";
            String fluidName = "";
            if (stack.func_77973_b() instanceof ItemFluidBucket) {
                BucketMaterial bucketMaterial;
                FluidStack fluidStack = ((ItemFluidBucket)stack.func_77973_b()).getFluid(stack);
                if (fluidStack != null && fluidStack.getFluid() != null) {
                    fluidName = fluidStack.getFluid().getName();
                }
                if ((bucketMaterial = BucketMaterialHandler.getMaterial(stack.func_77952_i())) != null) {
                    material = bucketMaterial.materialName;
                }
            }
            String key = material + ":" + fluidName;
            if (!model.cache.containsKey(key)) {
                IModel parent = model.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"fluid", (Object)fluidName, (Object)"material", (Object)material));
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(model.transforms), model.format, (java.util.function.Function)textureGetter);
                model.cache.put(key, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)model.cache.get(key);
        }
    }
}

