/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.bucket;

import com.builtbroken.mc.fluids.FluidModule;
import com.builtbroken.mc.fluids.bucket.BucketMaterial;
import com.builtbroken.mc.fluids.bucket.BucketMaterialHandler;
import com.builtbroken.mc.fluids.bucket.FluidCapabilityBucketWrapper;
import com.builtbroken.mc.fluids.mods.BucketHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidBucket
extends Item {
    public ItemFluidBucket(String name) {
        this.field_77777_bU = 1;
        this.setRegistryName(new ResourceLocation("vefluids", "veBucket"));
        this.func_77655_b(name);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77627_a(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidCapabilityBucketWrapper(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (!this.isEmpty(stack)) {
            list.add(I18n.func_135052_a((String)(this.func_77658_a() + ".fluid.name"), (Object[])new Object[0]) + ": " + this.getFluid(stack).getLocalizedName());
            list.add(I18n.func_135052_a((String)(this.func_77658_a() + ".fluid.amount.name"), (Object[])new Object[0]) + ": " + this.getFluid((ItemStack)stack).amount + "mb");
        } else if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            list.add("\u00a7c" + I18n.func_135052_a((String)(this.func_77658_a() + ".creative.void"), (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        boolean isBucketEmpty = this.isEmpty(itemstack);
        RayTraceResult movingobjectposition = this.func_77621_a(world, player, isBucketEmpty);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            TileEntity tile = world.func_175625_s(movingobjectposition.func_178782_a());
            if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, movingobjectposition.field_178784_b)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (!world.func_175660_a(player, movingobjectposition.func_178782_a())) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (isBucketEmpty) {
                if (player.func_175151_a(movingobjectposition.func_178782_a(), movingobjectposition.field_178784_b, itemstack)) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)this.pickupFluid(player, itemstack, world, movingobjectposition.func_178782_a()));
                }
            } else {
                BlockPos blockpos1;
                Block block = world.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c();
                Material material = block.func_149688_o(world.func_180495_p(movingobjectposition.func_178782_a()));
                if (player.func_175151_a(movingobjectposition.func_178782_a(), movingobjectposition.field_178784_b, itemstack)) {
                    BucketHandler handler;
                    if (BucketHandler.blockToHandler.containsKey(block) && (handler = BucketHandler.blockToHandler.get(block)) != null) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)handler.filledBucketClickBlock(player, itemstack, world, movingobjectposition.func_178782_a()));
                    }
                    if (!material.func_76220_a() && block.func_176200_f((IBlockAccess)world, movingobjectposition.func_178782_a())) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)this.placeFluid(player, itemstack, world, movingobjectposition.func_178782_a()));
                    }
                }
                if (player.func_175151_a(blockpos1 = movingobjectposition.func_178782_a().func_177972_a(movingobjectposition.field_178784_b), movingobjectposition.field_178784_b, itemstack)) {
                    BucketHandler handler;
                    if (BucketHandler.blockToHandler.containsKey(block) && (handler = BucketHandler.blockToHandler.get(block)) != null) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)handler.placeFluidClickBlock(player, itemstack, world, blockpos1));
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)this.placeFluid(player, itemstack, world, blockpos1));
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    protected ItemStack consumeBucket(ItemStack currentStack, EntityPlayer player, ItemStack newStack) {
        if (player.field_71075_bZ.field_75098_d) {
            return currentStack;
        }
        if (currentStack.func_190916_E() - 1 <= 0) {
            return newStack;
        }
        currentStack.func_190920_e(currentStack.func_190916_E() - 1);
        if (!player.field_71071_by.func_70441_a(newStack)) {
            player.func_71019_a(newStack, false);
        }
        return currentStack;
    }

    public ItemStack pickupFluid(EntityPlayer player, ItemStack itemstack, World world, BlockPos pos) {
        FluidStack drainedFluid;
        ItemStack bucket;
        BucketHandler handler;
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (BucketHandler.blockToHandler.containsKey(block) && (handler = BucketHandler.blockToHandler.get(block)) != null) {
            return handler.emptyBucketClickBlock(player, itemstack, world, pos);
        }
        if (block == Blocks.field_150355_j && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (world.func_175698_g(pos)) {
                bucket = new ItemStack((Item)this, 1, itemstack.func_77952_i());
                this.fill(bucket, new FluidStack(FluidRegistry.WATER, 1000), true);
                return this.consumeBucket(itemstack, player, bucket);
            }
        } else if (block == Blocks.field_150353_l && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            if (world.func_175698_g(pos)) {
                bucket = new ItemStack((Item)this, 1, itemstack.func_77952_i());
                this.fill(bucket, new FluidStack(FluidRegistry.LAVA, 1000), true);
                return this.consumeBucket(itemstack, player, bucket);
            }
        } else if (block instanceof IFluidBlock && ((IFluidBlock)block).canDrain(world, pos) && this.isValidFluidStack(drainedFluid = ((IFluidBlock)block).drain(world, pos, false))) {
            ItemStack bucket2 = new ItemStack((Item)this, 1, itemstack.func_77952_i());
            drainedFluid = ((IFluidBlock)block).drain(world, pos, true);
            if (this.isValidFluidStack(drainedFluid)) {
                this.fill(bucket2, drainedFluid, true);
                return this.consumeBucket(itemstack, player, bucket2);
            }
            if (world.func_180495_p(pos).func_177230_c() != block) {
                world.func_180501_a(pos, blockState, 3);
            }
        }
        return itemstack;
    }

    private boolean isValidFluidStack(FluidStack drainedFluid) {
        return drainedFluid != null && drainedFluid.getFluid() != null && drainedFluid.amount == 1000;
    }

    public ItemStack placeFluid(EntityPlayer player, ItemStack itemstack, World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.isFull(itemstack)) {
            FluidStack stack;
            if ((world.func_175623_d(pos) || block.func_176200_f((IBlockAccess)world, pos)) && (stack = this.getFluid(itemstack)) != null && stack.getFluid() != null && stack.getFluid().canBePlacedInWorld() && stack.getFluid().getBlock() != null) {
                if (world.field_73011_w.func_177500_n() && stack.getFluid().getUnlocalizedName().contains("water")) {
                    world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    for (int k = 0; k < 8; ++k) {
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                    }
                    return this.consumeBucket(itemstack, player, new ItemStack((Item)this, 1, itemstack.func_77952_i()));
                }
                if (!world.field_72995_K) {
                    // empty if block
                }
                if (stack.getFluid() == FluidRegistry.WATER) {
                    world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
                } else if (stack.getFluid() == FluidRegistry.LAVA) {
                    world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
                } else {
                    world.func_175656_a(pos, stack.getFluid().getBlock().func_176223_P());
                }
                return this.consumeBucket(itemstack, player, new ItemStack((Item)this, 1, itemstack.func_77952_i()));
            }
        } else if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".volume.notEnoughForFullBlock", new Object[0]));
        }
        return itemstack;
    }

    public boolean isEmpty(ItemStack container) {
        return this.getFluid(container) == null;
    }

    public boolean isFull(ItemStack container) {
        FluidStack stack = this.getFluid(container);
        if (stack != null) {
            return stack.amount == this.getCapacity(container);
        }
        return false;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource != null) {
            if (!doFill) {
                if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Fluid")) {
                    return Math.min(this.getCapacity(container), resource.amount);
                }
                FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
                if (stack == null) {
                    return Math.min(this.getCapacity(container), resource.amount);
                }
                if (!stack.isFluidEqual(resource)) {
                    return 0;
                }
                return Math.min(this.getCapacity(container) - stack.amount, resource.amount);
            }
            if (container.func_77978_p() == null) {
                container.func_77982_d(new NBTTagCompound());
            }
            if (!container.func_77978_p().func_74764_b("Fluid")) {
                NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
                if (this.getCapacity(container) < resource.amount) {
                    fluidTag.func_74768_a("Amount", this.getCapacity(container));
                    container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                    return this.getCapacity(container);
                }
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                return resource.amount;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            int filled = this.getCapacity(container) - stack.amount;
            if (resource.amount < filled) {
                stack.amount += resource.amount;
                filled = resource.amount;
            } else {
                stack.amount = this.getCapacity(container);
            }
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
            return filled;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (currentAmount == stack.amount) {
                container.func_77978_p().func_82580_o("Fluid");
                if (container.func_77978_p().func_82582_d()) {
                    container.func_77982_d(null);
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", currentAmount - stack.amount);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        return stack;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isEmpty(stack) ? Items.field_151133_ar.func_77639_j() : 1;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.getFluid() != null) {
            BucketHandler handler;
            if (BucketHandler.fluidToHandler.containsKey(fluid) && (handler = BucketHandler.fluidToHandler.get(fluid)) != null && handler.onUpdate(stack, world, entity, slot, held)) {
                return;
            }
            if (world.func_72820_D() % 5L == 0L) {
                boolean moltenFluid = fluid.getFluid().getTemperature(fluid) > 400;
                BucketMaterial material = BucketMaterialHandler.getMaterial(stack.func_77952_i());
                if (material != null) {
                    if (material.preventHotFluidUsage && moltenFluid) {
                        BucketMaterial damaged;
                        EntityLivingBase living;
                        if (material.burnEntityWithHotFluid && entity instanceof EntityLivingBase && world.field_73012_v.nextFloat() < (float)fluid.getFluid().getTemperature(fluid) / 1500.0f && !(living = (EntityLivingBase)entity).func_70045_F()) {
                            living.func_70015_d(1 + world.field_73012_v.nextInt(15));
                        }
                        if (material.damageBucketWithHotFluid && world.field_73012_v.nextFloat() < (float)fluid.getFluid().getTemperature(fluid) / 1500.0f && (damaged = material.getDamagedBucket(stack)) != null) {
                            stack.func_77964_b(damaged.metaValue);
                        }
                    }
                    if (material.enableFluidLeaking && fluid.getFluid().getViscosity(fluid) < material.viscosityToIgnoreLeaking && world.field_73012_v.nextFloat() < material.chanceToLeak) {
                        BucketHandler handler2;
                        if (BucketHandler.fluidToHandler.containsKey(fluid) && (handler2 = BucketHandler.fluidToHandler.get(fluid)) != null && handler2.onBucketLeaked(stack, world, entity, slot, held)) {
                            return;
                        }
                        int drain = material.amountToLeak <= 1 ? 1 : world.field_73012_v.nextInt(material.amountToLeak);
                        this.drain(stack, drain, true);
                        if (material.allowLeakToCauseFires && moltenFluid && world.field_73012_v.nextFloat() < material.leakFireChance) {
                            for (int i = 0; i < 7; ++i) {
                                int x = (int)entity.field_70165_t;
                                int y = (int)entity.field_70163_u + 2 - i;
                                int z = (int)entity.field_70161_v;
                                BlockPos pos = new BlockPos(x, y, z);
                                Block block = world.func_180495_p(pos).func_177230_c();
                                Block block2 = world.func_180495_p(pos.func_177984_a()).func_177230_c();
                                if (!block.isSideSolid(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP) || !block2.isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos.func_177984_a()) && !block2.func_176200_f((IBlockAccess)world, pos.func_177984_a())) continue;
                                world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        FluidStack fluid = this.getFluid(entityItem.func_92059_d());
        if (fluid != null && fluid.getFluid() != null) {
            BucketMaterial damaged;
            BucketMaterial material;
            BucketHandler handler;
            if (BucketHandler.fluidToHandler.containsKey(fluid) && (handler = BucketHandler.fluidToHandler.get(fluid)) != null && handler.onEntityItemUpdate(entityItem)) {
                return true;
            }
            if (entityItem.func_130014_f_().func_72820_D() % 5L == 0L && (material = BucketMaterialHandler.getMaterial(entityItem.func_92059_d().func_77952_i())) != null && material.preventHotFluidUsage && fluid.getFluid().getTemperature(fluid) > 400 && material.damageBucketWithHotFluid && entityItem.func_130014_f_().field_73012_v.nextFloat() < (float)fluid.getFluid().getTemperature(fluid) / 1500.0f && (damaged = material.getDamagedBucket(entityItem.func_92059_d())) != null) {
                entityItem.func_92059_d().func_77964_b(damaged.metaValue);
            }
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity != null) {
            Class<?> clazz = entity.getClass();
            if (BucketHandler.entityToHandler.containsKey(clazz) && BucketHandler.entityToHandler.get(clazz).rightClickEntity(stack, player, entity)) {
                return true;
            }
            if (entity instanceof EntityCow && this.isEmpty(stack)) {
                if (player.func_130014_f_().field_72995_K) {
                    return true;
                }
                Fluid fluid = FluidRegistry.getFluid((String)"milk");
                if (fluid != null) {
                    ItemStack newBucket = new ItemStack((Item)this, 1, stack.func_77952_i());
                    this.fill(newBucket, new FluidStack(fluid, 1000), true);
                    stack.func_190920_e(stack.func_190916_E() - 1);
                    player.field_71071_by.func_70441_a(newBucket);
                    player.field_71069_bz.func_75142_b();
                } else {
                    ((EntityCow)entity).func_70642_aH();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".error.fluid.milk.notRegistered", new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w()) {
            for (BucketMaterial material : BucketMaterialHandler.getMaterials()) {
                list.add((Object)new ItemStack((Item)this, 1, material.metaValue));
            }
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid == null) continue;
                ItemStack milkBucket = new ItemStack((Item)this, 1, BucketMaterialHandler.getMaterials().iterator().next().metaValue);
                this.fill(milkBucket, new FluidStack(fluid, 1000), true);
                list.add((Object)milkBucket);
            }
            for (BucketHandler handler : BucketHandler.bucketHandlers) {
                handler.getSubItems(this, (List)list);
            }
        }
    }

    public ItemStack getContainerItem(ItemStack itemstack) {
        if (this.isEmpty(itemstack)) {
            return null;
        }
        return new ItemStack((Item)FluidModule.bucket, 1, itemstack.func_77952_i());
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getFluid(stack) != null;
    }

    public String func_77667_c(ItemStack stack) {
        BucketMaterial material = BucketMaterialHandler.getMaterial(stack.func_77952_i());
        if (material != null) {
            return material.getUnlocalizedName(stack);
        }
        return super.func_77658_a();
    }

    public ItemStack getBucket(Fluid water) {
        ItemStack stack = new ItemStack((Item)this);
        this.fill(stack, new FluidStack(water, this.getCapacity(stack)), true);
        return stack;
    }
}

