/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.bucket;

import com.builtbroken.mc.fluids.bucket.ItemFluidBucket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidCapabilityBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    protected ItemStack container;

    public FluidCapabilityBucketWrapper(ItemStack container) {
        this.container = container;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    protected void setFluid(FluidStack fluidStack) {
        this.container = fluidStack == null ? new ItemStack(Items.field_151133_ar) : FluidUtil.getFilledBucket((FluidStack)fluidStack);
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidStack fluid = null;
        int cap = 1000;
        Item item = this.container.func_77973_b();
        if (item instanceof ItemFluidBucket) {
            fluid = ((ItemFluidBucket)item).getFluid(this.container);
            cap = ((ItemFluidBucket)item).getCapacity(this.container);
        }
        return new FluidTankProperties[]{new FluidTankProperties(fluid, cap)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        Item item = this.container.func_77973_b();
        if (item instanceof ItemFluidBucket) {
            return ((ItemFluidBucket)item).fill(this.container, resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        Item item = this.container.func_77973_b();
        if (item instanceof ItemFluidBucket && (((ItemFluidBucket)item).getFluid(this.container) == null || ((ItemFluidBucket)item).getFluid(this.container).getFluid() == resource.getFluid())) {
            return ((ItemFluidBucket)item).drain(this.container, resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        Item item = this.container.func_77973_b();
        if (item instanceof ItemFluidBucket) {
            return ((ItemFluidBucket)item).drain(this.container, maxDrain, doDrain);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
        }
        return null;
    }
}

