/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.bucket;

import com.builtbroken.mc.fluids.FluidModule;
import com.builtbroken.mc.fluids.api.reg.BucketMaterialRegistryEvent;
import com.builtbroken.mc.fluids.bucket.BucketMaterial;
import java.util.Collection;
import java.util.HashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BucketMaterialHandler {
    private static HashMap<String, BucketMaterial> nameToMaterial = new HashMap();
    private static HashMap<String, Integer> nameToMeta = new HashMap();
    private static HashMap<Integer, String> metaToName = new HashMap();
    private static int nextID = -1;

    public static void addMaterial(String name, BucketMaterial material) {
        BucketMaterialHandler.addMaterial(name, material, -1);
    }

    public static void addMaterial(String name, BucketMaterial material, int requestedMeta) {
        boolean registered = false;
        material.materialName = name;
        if (nameToMaterial.containsKey(name)) {
            FluidModule.logger.error("Entry: " + name + " is being overridden with " + material);
        }
        nameToMaterial.put(name, material);
        if (requestedMeta >= 0 && metaToName.get(requestedMeta) == null) {
            metaToName.put(requestedMeta, name);
            nameToMeta.put(name, requestedMeta);
            material.metaValue = requestedMeta;
            registered = true;
        } else if (nameToMeta.containsKey(name)) {
            material.metaValue = nameToMeta.get(name);
            registered = true;
        } else {
            while (nextID < 32000) {
                if (metaToName.get(++nextID) != null) continue;
                BucketMaterialHandler.reserveMaterial(name, nextID);
                material.metaValue = nextID;
                registered = true;
                break;
            }
            if (nextID >= 32000) {
                throw new RuntimeException("More than 32000 bucket materials have been registered. Report this to the author so more bucket items can be add to expand the max size. In all honesty this should never happen unless a mod is overloading the register.");
            }
        }
        if (registered) {
            MinecraftForge.EVENT_BUS.post((Event)new BucketMaterialRegistryEvent.Reg(material));
        }
    }

    public static void reserveMaterial(String name, int meta) {
        metaToName.put(meta, name);
        nameToMeta.put(name, meta);
    }

    public static BucketMaterial getMaterial(String name) {
        return nameToMaterial.get(name);
    }

    public static BucketMaterial getMaterial(int meta) {
        return BucketMaterialHandler.getMaterial(metaToName.get(meta));
    }

    public static String getName(int meta) {
        return metaToName.get(meta);
    }

    public static int getMeta(String name) {
        return nameToMeta.get(name);
    }

    public static Collection<BucketMaterial> getMaterials() {
        return nameToMaterial.values();
    }

    public static void load(Configuration bucketConfig) {
        String[] values;
        if (bucketConfig.hasKey("general", "metaValues") && (values = bucketConfig.getStringList("metaValues", "general", new String[]{""}, "")) != null) {
            for (String s : values) {
                if (s != null && s.contains(":")) {
                    String[] split = s.split(":");
                    try {
                        int meta = Integer.parseInt(split[1]);
                        BucketMaterialHandler.reserveMaterial(split[0], meta);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Invalid data [" + s + "] in metaValue field in " + bucketConfig.getConfigFile());
                    }
                }
                throw new RuntimeException("Invalid data [" + s + "] in metaValue field in " + bucketConfig.getConfigFile());
            }
        }
    }

    public static void save(Configuration bucketConfig) {
        Property prop = bucketConfig.get("general", "metaValues", new String[]{""});
        prop.setComment("List of materials to meta values for containers. Do not change any of these values unless you know what you are doing. Changing these values will affect the world save and could result in unexpected behavior.");
        String[] list = new String[BucketMaterialHandler.getMaterials().size()];
        int i = 0;
        for (BucketMaterial material : BucketMaterialHandler.getMaterials()) {
            list[i] = material.materialName + ":" + material.metaValue;
            ++i;
        }
        prop.set(list);
    }
}

