/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids.bucket;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class BucketMaterial {
    public boolean preventHotFluidUsage = true;
    public boolean damageBucketWithHotFluid = true;
    public boolean burnEntityWithHotFluid = true;
    public boolean enableFluidLeaking = false;
    public boolean allowLeakToCauseFires = true;
    public int viscosityToIgnoreLeaking = 3000;
    public int amountToLeak = 1;
    public float chanceToLeak = 0.03f;
    public float leakFireChance = 0.4f;
    public String localization;
    public String materialName;
    public int metaValue;
    protected ResourceLocation bucketResourceLocation;
    protected ResourceLocation fluidResourceLocation;

    public BucketMaterial(String localization, ResourceLocation bucketResourceLocation) {
        this.localization = localization;
        this.bucketResourceLocation = bucketResourceLocation;
    }

    public BucketMaterial getDamagedBucket(ItemStack stack) {
        return null;
    }

    public void handleConfig(Configuration config) {
        this.preventHotFluidUsage = config.getBoolean("PreventHotFluidUsage", "BucketUsage." + this.materialName, this.preventHotFluidUsage, "Enables settings that attempt to prevent players from wanting to use the bucket for moving hot fluids");
        this.damageBucketWithHotFluid = config.getBoolean("DamageBucketWithHotFluid", "BucketUsage." + this.materialName, this.damageBucketWithHotFluid, "Will randomly destroy the bucket if it contains hot fluid, lava in other words");
        this.burnEntityWithHotFluid = config.getBoolean("BurnPlayerWithHotFluid", "BucketUsage." + this.materialName, this.burnEntityWithHotFluid, "Will light the player on fire if the bucket contains a hot fluid, lava in other words");
        this.enableFluidLeaking = config.getBoolean("Enable", "BucketUsage." + this.materialName, this.enableFluidLeaking, "Allows fluid to slowly leak out of the bucket as a nerf. Requested by Darkosto");
        this.viscosityToIgnoreLeaking = config.getInt("MaxViscosity", "BucketUsage." + this.materialName, this.viscosityToIgnoreLeaking, -1, 10000, "At which point it the flow rate so slow that the leak is plugged, higher values are slower");
        this.amountToLeak = config.getInt("MaxLeakAmount", "BucketUsage." + this.materialName, this.amountToLeak, 0, 10000, "How much can leak from the bucket each time a leak happens, number is max amount and is randomly ranged between 0 - #");
        this.chanceToLeak = config.getFloat("LeakChance", "BucketUsage." + this.materialName, this.chanceToLeak, 0.0f, 1.0f, "What is the chance that a leak will happen, calculated each tick with high numbers being more often");
        this.allowLeakToCauseFires = config.getBoolean("AllowFires", "BucketUsage." + this.materialName, this.allowLeakToCauseFires, "If molten fluid leaks, should there be a chance to cause fires?");
        this.leakFireChance = config.getFloat("FireChance", "BucketUsage." + this.materialName, this.leakFireChance, 0.0f, 1.0f, "How often to cause fire from molten fluids leaking");
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "item." + this.localization;
    }

    public ResourceLocation getBucketResourceLocation() {
        return this.bucketResourceLocation;
    }

    public ResourceLocation getFluidResourceLocation() {
        return this.fluidResourceLocation;
    }
}

