/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.fluids;

import com.builtbroken.mc.fluids.CommonProxy;
import com.builtbroken.mc.fluids.api.reg.BucketMaterialRegistryEvent;
import com.builtbroken.mc.fluids.api.reg.FluidRegistryEvent;
import com.builtbroken.mc.fluids.bucket.BucketMaterial;
import com.builtbroken.mc.fluids.bucket.BucketMaterialHandler;
import com.builtbroken.mc.fluids.bucket.ItemFluidBucket;
import com.builtbroken.mc.fluids.fluid.FluidHelper;
import com.builtbroken.mc.fluids.fluid.Fluids;
import com.builtbroken.mc.fluids.mods.aa.SlimeRiceBucketRecipe;
import com.builtbroken.mc.fluids.mods.pam.PamBucketRecipe;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="vefluids", name="VoltzEngine Fluids module", version="0.8.0.10", acceptedMinecraftVersions="[1.12]")
@Mod.EventBusSubscriber(modid="vefluids")
public final class FluidModule {
    public static final String DOMAIN = "vefluids";
    public static final String MAJOR_VERSION = "0";
    public static final String MINOR_VERSION = "8";
    public static final String REVISION_VERSION = "0";
    public static final String BUILD_VERSION = "10";
    public static final String VERSION = "0.8.0.10";
    public static final boolean runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    public static final Logger logger = LogManager.getLogger((String)"SBM-NoMoreRain");
    public static Configuration config;
    public static Configuration bucketConfig;
    @SidedProxy(clientSide="com.builtbroken.mc.fluids.client.ClientProxy", serverSide="com.builtbroken.mc.fluids.CommonProxy")
    public static CommonProxy proxy;
    public static BucketMaterial materialIron;
    public static ItemFluidBucket bucket;

    public FluidModule() {
        if (runningAsDev) {
            FluidRegistry.enableUniversalBucket();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent preInitEvent) {
        config = new Configuration(new File(preInitEvent.getModConfigurationDirectory(), "bbm/Fluid_Module/core.cfg"));
        config.load();
        bucketConfig = new Configuration(new File(config.getConfigFile().getParent(), "bucket_materials.cfg"));
        bucketConfig.load();
        BucketMaterialHandler.load(bucketConfig);
        materialIron = new BucketMaterial("vefluids:ironBucket", new ResourceLocation(DOMAIN, "items/bucket"));
        BucketMaterialHandler.addMaterial("iron", materialIron, 30000);
        Fluids.load(config);
        proxy.preInit();
        if (runningAsDev) {
            for (Fluid fluid : FluidHelper.generatedFluids) {
                FluidRegistry.addBucketForFluid((Fluid)fluid);
            }
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        bucket = new ItemFluidBucket("vefluids:bucket");
        event.getRegistry().register((IForgeRegistryEntry)bucket);
        for (Block block : FluidHelper.generatedFluidBlocks) {
            event.getRegistry().register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        MinecraftForge.EVENT_BUS.post((Event)new FluidRegistryEvent.Pre());
        MinecraftForge.EVENT_BUS.post((Event)new FluidRegistryEvent.Post());
        MinecraftForge.EVENT_BUS.post((Event)new BucketMaterialRegistryEvent.Pre());
        MinecraftForge.EVENT_BUS.post((Event)new BucketMaterialRegistryEvent.Post());
        for (Fluid fluid : FluidHelper.generatedFluids) {
            FluidHelper.createBlockForFluidIfMissing(fluid, event);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (BucketMaterial material : BucketMaterialHandler.getMaterials()) {
            material.handleConfig(bucketConfig);
        }
        proxy.postInit();
        config.save();
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (bucket != null) {
            if (Loader.isModLoaded((String)"harvestcraft")) {
                if (config.getBoolean("EnableRegisteringMilkBucket", "PamHarvestCraftSupport", true, "Registers the milk bucket to the ore dictionary to be used in Pam's Harvest Craft recipes") && FluidRegistry.getFluid((String)"milk") != null) {
                    Item itemFreshMilk = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("harvestcraft:freshmilkItem"));
                    if (itemFreshMilk == null) {
                        logger.error("Failed to find item harvestcraft:freshmilkItem");
                    } else {
                        event.getRegistry().register((IForgeRegistryEntry)new PamBucketRecipe(new ItemStack(itemFreshMilk, 4, 0), Fluids.MILK.fluid));
                    }
                }
                if (config.getBoolean("EnableRegisteringFreshWaterBucket", "PamHarvestCraftSupport", true, "Registers the water bucket to the ore dictionary to be used in Pam's Harvest Craft recipes")) {
                    Item itemFreshWater = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("harvestcraft:freshwaterItem"));
                    if (itemFreshWater == null) {
                        logger.error("Failed to find item harvestcraft:freshwaterItem");
                    } else {
                        event.getRegistry().register((IForgeRegistryEntry)new PamBucketRecipe(new ItemStack(itemFreshWater, 4, 0), FluidRegistry.WATER));
                    }
                }
            }
            if (Loader.isModLoaded((String)"actuallyadditions")) {
                Item itemRice = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("actuallyadditions:item_misc"));
                if (itemRice == null) {
                    logger.error("Failed to find items from Actual additions required to register slime ball recipe");
                } else {
                    event.getRegistry().register((IForgeRegistryEntry)new SlimeRiceBucketRecipe(itemRice));
                }
            }
        }
    }

    @Mod.EventHandler
    public void loadCompleted(FMLLoadCompleteEvent event) {
        BucketMaterialHandler.save(bucketConfig);
        bucketConfig.save();
    }
}

