/*
 * Decompiled with CFR 0.152.
 */
package drzhark.customspawner;

import drzhark.customspawner.CustomDespawner;
import drzhark.customspawner.CustomSpawner;
import drzhark.customspawner.entity.EntityData;
import drzhark.customspawner.environment.EnvironmentSettings;
import drzhark.customspawner.type.EntitySpawnType;
import drzhark.customspawner.utils.CMSUtils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHooks {
    @SubscribeEvent
    public void peformCustomWorldGenSpawning(PopulateChunkEvent.Populate event) {
        int par1 = event.getChunkX() * 16;
        int par2 = event.getChunkZ() * 16;
        int x = event.getChunkX() * 16 + 8 + event.getWorld().field_73012_v.nextInt(16);
        int z = event.getChunkZ() * 16 + 8 + event.getWorld().field_73012_v.nextInt(16);
        CMSUtils.addWorldEnvironment(event.getWorld().field_73011_w.getClass());
        EnvironmentSettings environment = CMSUtils.getEnvironment(event.getWorld());
        for (EntitySpawnType entitySpawnType : environment.entitySpawnTypes.values()) {
            ArrayList<Biome.SpawnListEntry> customSpawnList;
            if (!(entitySpawnType.getChunkSpawnChance() > 0.0f) || entitySpawnType.getSpawnCap() <= 0 || (customSpawnList = entitySpawnType.getBiomeSpawnList(Biome.func_185362_a((Biome)event.getWorld().func_180494_b(new BlockPos(x, 0, z))))) == null) continue;
            CustomSpawner.performWorldGenSpawning(entitySpawnType, event.getWorld(), event.getWorld().func_180494_b(new BlockPos(x, 0, z)), par1 + 8, par2 + 8, 16, 16, event.getRand(), customSpawnList, environment.worldGenCreatureSpawning);
        }
    }

    @SubscribeEvent
    public void onLivingPackSize(LivingPackSizeEvent event) {
        World world = event.getEntity().field_70170_p;
        EnvironmentSettings environment = CMSUtils.getEnvironment(event.getEntity().field_70170_p);
        if (!this.isValidEntity(event.getEntity(), world, environment)) {
            return;
        }
        EntityData entityData = environment.classToEntityMapping.get(event.getEntityLiving().getClass());
        if (entityData != null) {
            event.setMaxPackSize(entityData.getMaxInChunk());
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        World world = event.getEntity().field_70170_p;
        EnvironmentSettings environment = CMSUtils.getEnvironment(event.getEntity().field_70170_p);
        if (!this.isValidEntity(event.getEntity(), world, environment)) {
            return;
        }
        EntityData entityData = environment.classToEntityMapping.get(event.getEntityLiving().getClass());
        if (entityData != null && !entityData.getCanSpawn()) {
            if (entityData.getEnvironment().debug) {
                entityData.getEnvironment().envLog.logger.info("Denied spawn for entity " + entityData.getEntityClass() + ". CanSpawn set to false or frequency set to 0!");
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingDespawn(LivingSpawnEvent.AllowDespawn event) {
        EntityData entityData;
        World world = event.getEntity().field_70170_p;
        EnvironmentSettings environment = CMSUtils.getEnvironment(event.getEntity().field_70170_p);
        if (!this.isValidEntity(event.getEntity(), world, environment)) {
            return;
        }
        if (CustomSpawner.forceDespawns) {
            EntityPlayer entityplayer;
            if (IMob.class.isAssignableFrom(event.getEntityLiving().getClass()) || IRangedAttackMob.class.isAssignableFrom(event.getEntityLiving().getClass()) || event.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
                return;
            }
            if (event.getEntityLiving() instanceof EntityTameable && ((EntityTameable)event.getEntityLiving()).func_70909_n()) {
                return;
            }
            if ((event.getEntityLiving() instanceof EntitySheep || event.getEntityLiving() instanceof EntityPig || event.getEntityLiving() instanceof EntityCow || event.getEntityLiving() instanceof EntityChicken) && CustomDespawner.isValidDespawnLightLevel(event.getEntity(), event.getWorld(), CMSUtils.getEnvironment((World)event.getWorld()).minDespawnLightLevel, CMSUtils.getEnvironment((World)event.getWorld()).maxDespawnLightLevel)) {
                return;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            event.getEntityLiving().func_189511_e(nbt);
            if (nbt != null) {
                if (nbt.func_74764_b("Owner") && !nbt.func_74779_i("Owner").equals("")) {
                    return;
                }
                if (nbt.func_74764_b("Tamed") && nbt.func_74767_n("Tamed")) {
                    return;
                }
            }
            if ((entityplayer = event.getWorld().func_72890_a((Entity)event.getEntityLiving(), -1.0)) != null) {
                double d = entityplayer.field_70165_t - event.getEntityLiving().field_70165_t;
                double d1 = entityplayer.field_70163_u - event.getEntityLiving().field_70163_u;
                double d2 = entityplayer.field_70161_v - event.getEntityLiving().field_70161_v;
                double distance = d * d + d1 * d1 + d2 * d2;
                if (distance > 16384.0) {
                    event.setResult(Event.Result.ALLOW);
                } else if (event.getEntityLiving().func_70654_ax() > 600) {
                    if (distance < 1024.0) {
                        return;
                    }
                    event.setResult(Event.Result.ALLOW);
                }
            }
            if (event.getResult() == Event.Result.ALLOW && CustomSpawner.debug) {
                int x = MathHelper.func_76128_c((double)event.getEntity().field_70165_t);
                int y = MathHelper.func_76128_c((double)event.getEntity().func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)event.getEntity().field_70161_v);
                CMSUtils.getEnvironment((World)event.getWorld()).envLog.logger.info("Forced Despawn of entity " + event.getEntityLiving() + " at " + x + ", " + y + ", " + z + ". To prevent forced despawns, use /moc forceDespawns false.");
            }
        }
        if ((entityData = environment.classToEntityMapping.get(event.getEntityLiving().getClass())) != null && entityData.getLivingSpawnType() == CMSUtils.getEnvironment((World)event.getEntity().field_70170_p).LIVINGTYPE_UNDERGROUND) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        CMSUtils.addWorldEnvironment(event.getWorld().field_73011_w.getClass());
        GameRules gameRule = event.getWorld().func_82736_K();
        if (gameRule != null) {
            gameRule.func_82764_b("doMobSpawning", new Boolean(CustomSpawner.doMobSpawning).toString());
        }
    }

    @SubscribeEvent
    public void structureMapGen(InitMapGenEvent event) {
        if (event.getType() == InitMapGenEvent.EventType.NETHER_BRIDGE) {
            if (CustomSpawner.environmentMap.get(WorldProviderHell.class) == null) {
                CMSUtils.addWorldEnvironment(WorldProviderHell.class);
            }
            CustomSpawner.environmentMap.get(WorldProviderHell.class).structureData.registerStructure(CustomSpawner.environmentMap.get(WorldProviderHell.class), event.getType(), event.getOriginalGen());
        } else if (event.getType() == InitMapGenEvent.EventType.SCATTERED_FEATURE) {
            if (CustomSpawner.environmentMap.get(WorldProviderSurface.class) == null) {
                CMSUtils.addWorldEnvironment(WorldProviderSurface.class);
            }
            CustomSpawner.environmentMap.get(WorldProviderSurface.class).structureData.registerStructure(CustomSpawner.environmentMap.get(WorldProviderSurface.class), event.getType(), event.getOriginalGen());
        }
    }

    private boolean isValidEntity(Entity entity, World world, EnvironmentSettings environment) {
        if (entity == null || world == null || environment == null) {
            if (CustomSpawner.debug) {
                if (entity == null) {
                    CustomSpawner.globalLog.logger.info("Event fired with NULL entity!");
                } else if (world == null) {
                    CustomSpawner.globalLog.logger.info("Event fired with NULL world for entity " + entity);
                } else {
                    CustomSpawner.globalLog.logger.info("No environment found in world " + world.func_72912_H().func_76065_j() + ", dim " + world.field_73011_w.getDimension() + ", provider " + world.field_73011_w.getClass().getSimpleName() + " for entity " + entity);
                }
                Thread.dumpStack();
            }
            return false;
        }
        return true;
    }
}

