/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CoroutineExceptionHandler;
import kotlinx.coroutines.experimental.CoroutineExceptionHandlerImplKt;
import kotlinx.coroutines.experimental.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a%\u0010\u0000\u001a\u00020\u00012\u001a\b\u0004\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u0087\b\u001a\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"CoroutineExceptionHandler", "Lkotlinx/coroutines/experimental/CoroutineExceptionHandler;", "handler", "Lkotlin/Function2;", "Lkotlin/coroutines/experimental/CoroutineContext;", "", "", "handleCoroutineException", "context", "exception", "kotlinx-coroutines-core"})
public final class CoroutineExceptionHandlerKt {
    /*
     * WARNING - void declaration
     */
    public static final void handleCoroutineException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        try {
            CoroutineExceptionHandler coroutineExceptionHandler = (CoroutineExceptionHandler)context.get(CoroutineExceptionHandler.Key);
            if (coroutineExceptionHandler != null) {
                CoroutineExceptionHandler coroutineExceptionHandler2;
                CoroutineExceptionHandler it = coroutineExceptionHandler2 = coroutineExceptionHandler;
                it.handleException(context, exception);
                return;
            }
            if (exception instanceof CancellationException) {
                return;
            }
            Job job = (Job)context.get(Job.Key);
            if (job != null) {
                job.cancel(exception);
            }
            CoroutineExceptionHandlerImplKt.handleCoroutineExceptionImpl(context, exception);
        }
        catch (Throwable handlerException) {
            void $receiver$iv;
            RuntimeException runtimeException;
            if (handlerException == exception) {
                throw exception;
            }
            RuntimeException $receiver = runtimeException = new RuntimeException("Exception while trying to handle coroutine exception", exception);
            Throwable throwable = $receiver;
            Throwable other$iv = handlerException;
            ExceptionsKt.addSuppressed((Throwable)$receiver$iv, other$iv);
            throw (Throwable)runtimeException;
        }
    }

    @NotNull
    public static final CoroutineExceptionHandler CoroutineExceptionHandler(@NotNull Function2<? super CoroutineContext, ? super Throwable, Unit> handler) {
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        return new CoroutineExceptionHandler(handler, CoroutineExceptionHandler.Key){
            final /* synthetic */ Function2 $handler;

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Intrinsics.checkParameterIsNotNull(context, "context");
                Intrinsics.checkParameterIsNotNull(exception, "exception");
                this.$handler.invoke(context, exception);
            }
            {
                this.$handler = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }
}

