/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BinaryVersion {
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final List<Integer> rest;
    @NotNull
    private final int[] numbers;
    private static final int UNKNOWN = -1;
    public static final Companion Companion = new Companion(null);

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    @NotNull
    public final int[] toArray() {
        return this.numbers;
    }

    protected final boolean isCompatibleTo(@NotNull BinaryVersion ourVersion) {
        Intrinsics.checkParameterIsNotNull(ourVersion, "ourVersion");
        return this.major == 0 ? ourVersion.major == 0 && this.minor == ourVersion.minor : this.major == ourVersion.major && this.minor <= ourVersion.minor;
    }

    @NotNull
    public String toString() {
        int item$iv;
        int it;
        int[] $receiver$iv = this.toArray();
        ArrayList<Integer> list$iv = new ArrayList<Integer>();
        int n = $receiver$iv.length;
        for (int i = 0; i < n && (it = (item$iv = $receiver$iv[i])) != UNKNOWN; ++i) {
            list$iv.add(item$iv);
        }
        List versions = list$iv;
        return versions.isEmpty() ? "unknown" : CollectionsKt.joinToString$default(versions, ".", null, null, 0, null, null, 62, null);
    }

    public boolean equals(@Nullable Object other) {
        return other != null && Intrinsics.areEqual(this.getClass(), other.getClass()) && this.major == ((BinaryVersion)other).major && this.minor == ((BinaryVersion)other).minor && this.patch == ((BinaryVersion)other).patch && Intrinsics.areEqual(this.rest, ((BinaryVersion)other).rest);
    }

    public int hashCode() {
        int result = this.major;
        result += 31 * result + this.minor;
        result += 31 * result + this.patch;
        result += 31 * result + ((Object)this.rest).hashCode();
        return result;
    }

    public BinaryVersion(int ... numbers) {
        Intrinsics.checkParameterIsNotNull(numbers, "numbers");
        this.numbers = numbers;
        Integer n = ArraysKt.getOrNull(this.numbers, 0);
        this.major = n != null ? n : UNKNOWN;
        Integer n2 = ArraysKt.getOrNull(this.numbers, 1);
        this.minor = n2 != null ? n2 : UNKNOWN;
        Integer n3 = ArraysKt.getOrNull(this.numbers, 2);
        this.patch = n3 != null ? n3 : UNKNOWN;
        this.rest = this.numbers.length > 3 ? CollectionsKt.toList((Iterable)ArraysKt.asList(this.numbers).subList(3, this.numbers.length)) : CollectionsKt.emptyList();
    }

    static {
        UNKNOWN = -1;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

