/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.cap.TeslaHandler;
import zmaster587.libVulpes.energy.IPower;
import zmaster587.libVulpes.tile.TileEntityMachine;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TileEntityPowerMachine
extends TileEntityMachine
implements IPower,
IUniversalEnergy {
    protected UniversalBattery energy;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energy.writeToNBT(nbt);
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)new ForgePowerCapability(this);
        }
        if (TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability)) {
            return (T)TeslaHandler.getHandler(this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy.readFromNBT(nbt);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energy.acceptEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    public boolean hasEnergy() {
        return this.energy.getUniversalEnergyStored() > 0;
    }

    @Override
    public void setEnergyStored(int value) {
        this.energy.setEnergyStored(value);
    }

    public void removePower(int amt) {
        this.energy.extractEnergy(amt, false);
    }

    public int getPower() {
        return this.energy.getUniversalEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing arg0) {
        return true;
    }
}

