/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.libVulpes.recipe.RecipesMachine;

public abstract class RecipeMachineFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        LinkedList<List<ItemStack>> inputs = new LinkedList();
        List<Object> outputs = new LinkedList();
        LinkedList<FluidStack> inputFluids = new LinkedList();
        LinkedList<FluidStack> outputFluids = new LinkedList();
        int timeTaken = 0;
        int energy = 0;
        try {
            JsonElement fluidResultElement;
            JsonElement fluidIngredientElement;
            JsonElement itemResults;
            JsonElement ingredientElement = json.get("itemingredients");
            if (ingredientElement != null) {
                inputs = this.getIngredientsFromArray(context, ingredientElement);
            }
            if ((itemResults = json.get("itemresults")) != null) {
                if (itemResults.isJsonArray()) {
                    for (JsonElement element : itemResults.getAsJsonArray()) {
                        outputs.addAll(this.getIngredients(context, element));
                    }
                } else {
                    outputs = this.getIngredients(context, itemResults);
                }
            }
            if ((fluidIngredientElement = json.get("fluidingredients")) != null) {
                inputFluids = this.getFluidStacks(context, fluidIngredientElement);
            }
            if ((fluidResultElement = json.get("fluidresults")) != null) {
                outputFluids = this.getFluidStacks(context, fluidResultElement);
            }
            timeTaken = json.get("time").getAsInt();
            energy = json.get("energy").getAsInt();
        }
        catch (NullPointerException e) {
            throw new JsonParseException("Missing parameters");
        }
        RecipesMachine.getInstance().recipeList.get(this.getMachine()).add(new RecipesMachine.Recipe(outputs, inputs, outputFluids, inputFluids, timeTaken, energy, new HashMap<Integer, String>()));
        return new RecipesMachine.DummyRecipe();
    }

    public abstract Class getMachine();

    public List<FluidStack> getFluidStacks(JsonContext context, JsonElement json) {
        if (!json.isJsonArray()) {
            return null;
        }
        LinkedList<FluidStack> fluidstacks = new LinkedList<FluidStack>();
        JsonArray ingredientListJSON = json.getAsJsonArray();
        for (JsonElement ingredient : ingredientListJSON) {
            fluidstacks.add(this.parseFluid(context, ingredient));
        }
        return fluidstacks;
    }

    public FluidStack parseFluid(JsonContext context, JsonElement json) {
        String fluidname = json.getAsJsonObject().get("fluid").getAsString();
        int size = json.getAsJsonObject().get("amount").getAsInt();
        return new FluidStack(FluidRegistry.getFluid((String)fluidname), size);
    }

    List<List<ItemStack>> getIngredientsFromArray(JsonContext context, JsonElement json) {
        if (!json.isJsonArray()) {
            return null;
        }
        JsonArray ingredientListJSON = json.getAsJsonArray();
        LinkedList<List<ItemStack>> inputs = new LinkedList<List<ItemStack>>();
        for (JsonElement ingredient : ingredientListJSON) {
            inputs.add(this.getIngredients(context, ingredient));
        }
        return inputs;
    }

    List<ItemStack> getIngredients(JsonContext context, JsonElement json) {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (ItemStack stack : CraftingHelper.getIngredient((JsonElement)json, (JsonContext)context).func_193365_a()) {
            int count = 1;
            ItemStack stack2 = stack.func_77946_l();
            JsonElement countElem = json.getAsJsonObject().get("count");
            if (countElem != null) {
                count = countElem.getAsInt();
            }
            stack2.func_190920_e(count);
            stacks.add(stack2);
        }
        return stacks;
    }
}

