/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Crusher")
public class Crusher {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int energy, @Optional IItemStack secondaryOutput, @Optional double secondaryChance) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            CraftTweakerAPI.getLogger().logError("Did not add crusher recipe for " + output.getDisplayName() + ", input was null");
            return;
        }
        CrusherRecipe r = new CrusherRecipe(CraftTweakerHelper.toStack(output), oInput, energy);
        if (r.input == null) {
            CraftTweakerAPI.getLogger().logError("Did not add crusher recipe for " + output.getDisplayName() + ", converted input was null");
            return;
        }
        if (secondaryOutput != null) {
            r.addToSecondaryOutput(CraftTweakerHelper.toStack(secondaryOutput), Float.valueOf((float)secondaryChance));
        }
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeRecipesForInput(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new RemoveForInput(CraftTweakerHelper.toStack(input)));
    }

    private static class RemoveForInput
    implements IAction {
        private final ItemStack input;
        List<CrusherRecipe> removedRecipes;

        public RemoveForInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            this.removedRecipes = CrusherRecipe.removeRecipesForInput(this.input);
        }

        public String describe() {
            return "Removing Crusher Recipe for input: " + this.input.func_82833_r();
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<CrusherRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = CrusherRecipe.removeRecipesForOutput(this.output);
        }

        public String describe() {
            return "Removing Crusher Recipe for output: " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final CrusherRecipe recipe;

        public Add(CrusherRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CrusherRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Crusher Recipe for " + this.recipe.output.func_82833_r();
        }
    }
}

