/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.teleporter;

import erebus.Erebus;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.teleporter.TeleporterErebus;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class TeleporterHandler {
    private static TeleporterHandler INSTANCE = new TeleporterHandler();
    private final TObjectByteMap<UUID> waitingPlayers = new TObjectByteHashMap();
    private boolean checkWaitingPlayers = false;
    private TeleporterErebus teleportToOverworld;
    private TeleporterErebus teleportToErebus;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void transferToOverworld(Entity entity) {
        INSTANCE.transferEntity(entity, 0);
    }

    public static void transferToErebus(Entity entity) {
        INSTANCE.transferEntity(entity, ConfigHandler.INSTANCE.erebusDimensionID);
    }

    private TeleporterHandler() {
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!(e.getWorld() instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)e.getWorld();
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.teleportToOverworld = new TeleporterErebus(world);
            world.customTeleporters.add(this.teleportToOverworld);
        } else if (world.field_73011_w.func_186058_p() == Erebus.dimensionType) {
            this.teleportToErebus = new TeleporterErebus(world);
            world.customTeleporters.add(this.teleportToErebus);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        UUID[] ids;
        if (e.phase != TickEvent.Phase.END || !this.checkWaitingPlayers) {
            return;
        }
        for (UUID uuid : ids = (UUID[])this.waitingPlayers.keys((Object[])new UUID[this.waitingPlayers.size()])) {
            if (this.waitingPlayers.adjustOrPutValue((Object)uuid, (byte)-1, (byte)0) > 0) continue;
            this.waitingPlayers.remove((Object)uuid);
            if (!this.waitingPlayers.isEmpty()) continue;
            this.checkWaitingPlayers = false;
        }
    }

    private void transferEntity(Entity entity, int dimensionId) {
        if (dimensionId != 0 && dimensionId != ConfigHandler.INSTANCE.erebusDimensionID) {
            throw new IllegalArgumentException("Supplied invalid dimension ID into Erebus teleporter: " + dimensionId);
        }
        World world = entity.func_130014_f_();
        if (!world.field_72995_K && !entity.field_70128_L) {
            if (entity instanceof EntityPlayerMP) {
                if (entity instanceof FakePlayer) {
                    return;
                }
                EntityPlayerMP player = (EntityPlayerMP)entity;
                if (this.waitingPlayers.containsKey((Object)player.func_110124_au())) {
                    this.waitingPlayers.put((Object)player.func_110124_au(), (byte)20);
                    return;
                }
                this.waitingPlayers.put((Object)player.func_110124_au(), (byte)40);
                this.checkWaitingPlayers = true;
                player.field_71133_b.func_184103_al().transferPlayerToDimension(player, dimensionId, (Teleporter)(dimensionId == 0 ? this.teleportToOverworld : this.teleportToErebus));
                player.field_71088_bW = 0;
            } else {
                MinecraftServer server = world.func_73046_m();
                WorldServer toWorld = server.func_71218_a(dimensionId);
                entity.func_184174_b(false);
                world.func_72973_f(entity);
                entity.field_71093_bK = dimensionId;
                entity.field_70128_L = false;
                WorldServer oldWorld = server.func_71218_a(entity.field_71093_bK);
                server.func_184103_al().transferEntityToWorld(entity, dimensionId, oldWorld, toWorld, (Teleporter)new TeleporterErebus(toWorld));
                toWorld.func_72870_g(entity);
            }
        }
    }
}

