/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.ModBlocks;
import erebus.blocks.BlockLeavesErebus;
import erebus.blocks.EnumWood;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenErebusHugeTree
extends WorldGenerator {
    private int baseHeight;
    private final boolean thorns;
    private final Block woodBlock;
    private final IBlockState leafBlock;

    public WorldGenErebusHugeTree(boolean notify, boolean genThorns, EnumWood wood) {
        super(notify);
        this.thorns = genThorns;
        this.woodBlock = wood.getLog();
        this.leafBlock = wood.getLeaves().func_176223_P().func_177226_a((IProperty)BlockLeavesErebus.field_176236_b, (Comparable)Boolean.valueOf(false));
    }

    public void prepare(int baseHeight) {
        this.baseHeight = baseHeight;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int height = rand.nextInt(3) + this.baseHeight;
        boolean var7 = true;
        if (y >= 1 && y + height + 1 <= 256) {
            IBlockState block;
            int var11;
            int var10;
            for (int var8 = y; var8 <= y + 1 + height; ++var8) {
                int var9 = 2;
                if (var8 == y) {
                    var9 = 1;
                }
                if (var8 >= y + 1 + height - 2) {
                    var9 = 2;
                }
                for (var10 = x - var9; var10 <= x + var9 && var7; ++var10) {
                    for (var11 = z - var9; var11 <= z + var9 && var7; ++var11) {
                        if (var8 >= 0 && var8 < 256) {
                            block = world.func_180495_p(new BlockPos(var10, var8, var11));
                            if (block.func_177230_c() instanceof BlockLeaves || block == Blocks.field_150349_c.func_176223_P() || block == Blocks.field_150346_d.func_176223_P() || block.func_185904_a() == Material.field_151575_d || block.func_177230_c().func_176200_f((IBlockAccess)world, new BlockPos(var10, var8, var11))) continue;
                            var7 = false;
                            continue;
                        }
                        var7 = false;
                    }
                }
            }
            if (!var7) {
                return false;
            }
            block = world.func_180495_p(new BlockPos(x, y - 1, z));
            if ((block == Blocks.field_150349_c.func_176223_P() || block == Blocks.field_150346_d.func_176223_P()) && y < 256 - height - 1) {
                world.func_175656_a(new BlockPos(x, y - 1, z), Blocks.field_150346_d.func_176223_P());
                world.func_175656_a(new BlockPos(x + 1, y - 1, z), Blocks.field_150346_d.func_176223_P());
                world.func_175656_a(new BlockPos(x, y - 1, z + 1), Blocks.field_150346_d.func_176223_P());
                world.func_175656_a(new BlockPos(x + 1, y - 1, z + 1), Blocks.field_150346_d.func_176223_P());
                this.growLeaves(world, x, z, y + height, 2, rand);
                for (int var14 = y + height - 2 - rand.nextInt(4); var14 > y + height / 2; var14 -= 2 + rand.nextInt(4)) {
                    float var15 = rand.nextFloat() * (float)Math.PI * 2.0f;
                    var11 = x + (int)(0.5f + MathHelper.func_76134_b((float)var15) * 4.0f);
                    int var12 = z + (int)(0.5f + MathHelper.func_76126_a((float)var15) * 4.0f);
                    this.growLeaves(world, var11, var12, var14, 0, rand);
                    for (int var13 = 0; var13 < 5; ++var13) {
                        var11 = x + (int)(1.5f + MathHelper.func_76134_b((float)var15) * (float)var13);
                        var12 = z + (int)(1.5f + MathHelper.func_76126_a((float)var15) * (float)var13);
                        this.func_175903_a(world, new BlockPos(var11, var14 - 3 + var13 / 2, var12), this.woodBlock.func_176223_P());
                    }
                }
                for (var10 = 0; var10 < height; ++var10) {
                    pos = new BlockPos(x, y + var10, z);
                    block = world.func_180495_p(pos);
                    if (block.func_177230_c().func_176200_f((IBlockAccess)world, pos) || block.func_177230_c().isLeaves(block, (IBlockAccess)world, pos)) {
                        this.func_175903_a(world, new BlockPos(x, y + var10, z), this.woodBlock.func_176223_P());
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.func_175623_d(new BlockPos(x - 1, y + var10, z)) && this.thorns) {
                                world.func_180501_a(new BlockPos(x - 1, y + var10, z), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 2);
                            }
                            if (rand.nextInt(3) > 0 && world.func_175623_d(new BlockPos(x, y + var10, z - 1)) && this.thorns) {
                                world.func_180501_a(new BlockPos(x, y + var10, z - 1), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    }
                    if (var10 >= height - 1) continue;
                    pos = new BlockPos(x + 1, y + var10, z);
                    block = world.func_180495_p(pos);
                    if (block.func_177230_c().func_176200_f((IBlockAccess)world, pos) || block.func_177230_c().isLeaves(block, (IBlockAccess)world, pos)) {
                        this.func_175903_a(world, new BlockPos(x + 1, y + var10, z), this.woodBlock.func_176223_P());
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.func_175623_d(new BlockPos(x + 2, y + var10, z)) && this.thorns) {
                                world.func_180501_a(new BlockPos(x + 2, y + var10, z), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true)), 2);
                            }
                            if (rand.nextInt(3) > 0 && world.func_175623_d(new BlockPos(x + 1, y + var10, z - 1)) && this.thorns) {
                                world.func_180501_a(new BlockPos(x + 1, y + var10, z - 1), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    }
                    if ((block = world.func_180495_p(pos = new BlockPos(x + 1, y + var10, z + 1))).func_177230_c().func_176200_f((IBlockAccess)world, pos) || block.func_177230_c().isLeaves(block, (IBlockAccess)world, pos)) {
                        this.func_175903_a(world, new BlockPos(x + 1, y + var10, z + 1), this.woodBlock.func_176223_P());
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.func_175623_d(new BlockPos(x + 2, y + var10, z + 1)) && this.thorns) {
                                world.func_180501_a(new BlockPos(x + 2, y + var10, z + 1), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true)), 2);
                            }
                            if (rand.nextInt(3) > 0 && world.func_175623_d(new BlockPos(x + 1, y + var10, z + 2)) && this.thorns) {
                                world.func_180501_a(new BlockPos(x + 1, y + var10, z + 2), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    }
                    if (!(block = world.func_180495_p(pos = new BlockPos(x, y + var10, z + 1))).func_177230_c().func_176200_f((IBlockAccess)world, pos) && !block.func_177230_c().isLeaves(block, (IBlockAccess)world, pos)) continue;
                    this.func_175903_a(world, new BlockPos(x, y + var10, z + 1), this.woodBlock.func_176223_P());
                    if (var10 <= 0) continue;
                    if (rand.nextInt(3) > 0 && world.func_175623_d(new BlockPos(x - 1, y + var10, z + 1)) && this.thorns) {
                        world.func_180501_a(new BlockPos(x - 1, y + var10, z + 1), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 2);
                    }
                    if (rand.nextInt(3) <= 0 || !world.func_175623_d(new BlockPos(x, y + var10, z + 2)) || !this.thorns) continue;
                    world.func_180501_a(new BlockPos(x, y + var10, z + 2), ModBlocks.THORNS.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)), 2);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growLeaves(World world, int par2, int par3, int par4, int par5, Random par6Random) {
        int var7 = 2;
        for (int var8 = par4 - var7; var8 <= par4; ++var8) {
            int var9 = var8 - par4;
            int var10 = par5 + 1 - var9;
            for (int var11 = par2 - var10; var11 <= par2 + var10 + 1; ++var11) {
                int var12 = var11 - par2;
                for (int var13 = par3 - var10; var13 <= par3 + var10 + 1; ++var13) {
                    int var14 = var13 - par3;
                    IBlockState block = world.func_180495_p(new BlockPos(var11, var8, var13));
                    if (var12 < 0 && var14 < 0 && var12 * var12 + var14 * var14 > var10 * var10 || (var12 > 0 || var14 > 0) && var12 * var12 + var14 * var14 > (var10 + 1) * (var10 + 1) || par6Random.nextInt(4) == 0 && var12 * var12 + var14 * var14 > (var10 - 1) * (var10 - 1) || block != null && !block.func_177230_c().canBeReplacedByLeaves(block, (IBlockAccess)world, new BlockPos(var11, var8, var13))) continue;
                    this.func_175903_a(world, new BlockPos(var11, var8, var13), this.leafBlock);
                }
            }
        }
    }
}

