/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.plant;

import erebus.blocks.BlockLogErebus;
import erebus.blocks.EnumWood;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenRottenLogs
extends WorldGenerator {
    private int length = -1;
    private int baseRadius = -1;
    private byte direction;
    protected Block log;

    public WorldGenRottenLogs(int length, int baseRadius, byte direction) {
        this.length = length;
        this.baseRadius = baseRadius;
        this.direction = direction;
        this.log = EnumWood.ROTTEN.getLog();
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.direction == 1) {
            for (int xx = x - this.baseRadius; this.baseRadius + x >= xx; ++xx) {
                for (int zz = z - this.length; this.length + z - 1 >= zz; ++zz) {
                    for (int yy = y + 1; yy <= y + this.baseRadius * 2; ++yy) {
                        if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                        return false;
                    }
                }
            }
            for (int zz = z - this.length; this.length + z - 1 >= zz; ++zz) {
                for (int i = this.baseRadius * -1; i <= this.baseRadius; ++i) {
                    for (int j = this.baseRadius * -1; j <= this.baseRadius; ++j) {
                        double dSq = i * i + j * j;
                        if (Math.round(Math.sqrt(dSq)) == (long)this.baseRadius) {
                            world.func_180501_a(new BlockPos(x + i, y + j + this.baseRadius, zz), this.log.func_176223_P().func_177226_a((IProperty)BlockLogErebus.field_176299_a, (Comparable)BlockLog.EnumAxis.Z), 2);
                            if (rand.nextInt(12) == 0) {
                                world.func_175698_g(new BlockPos(x + i, y + j + this.baseRadius, zz));
                            }
                            if ((zz != z - this.length || rand.nextInt(2) != 0) && (zz != z + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(new BlockPos(x + i, y + j + this.baseRadius, zz));
                            continue;
                        }
                        world.func_175698_g(new BlockPos(x + i, y + j + this.baseRadius, zz));
                    }
                }
            }
        } else {
            int xx;
            for (xx = x - this.length; this.length + x - 1 >= xx; ++xx) {
                for (int zz = z - this.baseRadius; this.baseRadius + z >= zz; ++zz) {
                    for (int yy = y + 1; yy <= y + this.baseRadius * 2; ++yy) {
                        if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                        return false;
                    }
                }
            }
            for (xx = x - this.length; this.length + x - 1 >= xx; ++xx) {
                for (int i = this.baseRadius * -1; i <= this.baseRadius; ++i) {
                    for (int j = this.baseRadius * -1; j <= this.baseRadius; ++j) {
                        double dSq = i * i + j * j;
                        if (Math.round(Math.sqrt(dSq)) == (long)this.baseRadius) {
                            world.func_180501_a(new BlockPos(xx, y + j + this.baseRadius, z + i), this.log.func_176223_P().func_177226_a((IProperty)BlockLogErebus.field_176299_a, (Comparable)BlockLog.EnumAxis.X), 2);
                            if (rand.nextInt(12) == 0) {
                                world.func_175698_g(new BlockPos(xx, y + j + this.baseRadius, z + i));
                            }
                            if ((xx != x - this.length || rand.nextInt(2) != 0) && (xx != x + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(new BlockPos(xx, y + j + this.baseRadius, z + i));
                            continue;
                        }
                        world.func_175698_g(new BlockPos(xx, y + j + this.baseRadius, z + i));
                    }
                }
            }
        }
        return true;
    }
}

