/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.ModBlocks;
import erebus.blocks.BlockDoubleHeightPlant;
import erebus.blocks.BlockSmallPlant;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.ChunkProviderErebus;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.FeatureType;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenGasVents;
import erebus.world.feature.decoration.WorldGenPonds;
import erebus.world.feature.decoration.WorldGenQuickSand;
import erebus.world.feature.decoration.WorldGenRottenAcacia;
import erebus.world.feature.plant.WorldGenAlgae;
import erebus.world.feature.plant.WorldGenMossPatch;
import erebus.world.feature.plant.WorldGenRottenLogs;
import erebus.world.feature.plant.WorldGenSwampBush;
import erebus.world.feature.plant.WorldGenVinesErebus;
import erebus.world.feature.structure.WorldGenDragonflyDungeon;
import erebus.world.feature.tree.WorldGenMarshwoodTree;
import erebus.world.feature.tree.WorldGenMossbarkTree;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeDecoratorSubmergedSwamp
extends BiomeDecoratorBaseErebus {
    private final WorldGenDragonflyDungeon genGiantLilyPad = new WorldGenDragonflyDungeon();
    private final WorldGenerator genTreeMarshwood = new WorldGenMarshwoodTree();
    private final WorldGenerator genTreeMossbark = new WorldGenMossbarkTree();
    protected final WorldGenSwampBush genSwampBush = new WorldGenSwampBush();
    private final WorldGenVinesErebus genVines = new WorldGenVinesErebus(35, 5);
    private final WorldGenPonds genPonds = new WorldGenPonds();
    private final WorldGenQuickSand genQuickSand = new WorldGenQuickSand();
    protected final WorldGenerator genMossPatch = new WorldGenMossPatch(0);
    private final WorldGenRottenAcacia genRottenAcacia = new WorldGenRottenAcacia();
    protected final WorldGenGasVents genGasVent = new WorldGenGasVents();
    private final WorldGenAlgae genAlgae = new WorldGenAlgae();
    private final WorldGenReed genReed = new WorldGenReed();
    private static final int[] offsetX = new int[]{-1, 1, 0, 0};
    private static final int[] offsetZ = new int[]{0, 0, -1, 1};

    @Override
    protected void populate() {
        this.attempt = 0;
        while (this.attempt < 800) {
            this.xx = this.x + 16;
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + 16;
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.MIXED, pos)) {
                this.genPonds.prepare((this.rand.nextDouble() + 0.7) * 1.5);
                this.genPonds.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
    }

    @Override
    public void decorate() {
        BlockPos pos;
        int attempt;
        for (attempt = 0; attempt < 15 && !this.genGiantLilyPad.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), ChunkProviderErebus.swampWaterHeight, this.z + this.offsetXZ())); ++attempt) {
        }
        for (attempt = 0; attempt < 5; ++attempt) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            this.genAlgae.func_180709_b(this.world, this.rand, pos);
        }
        this.attempt = 0;
        while (this.attempt < 2) {
            this.xx = this.x + this.offsetXZ();
            this.yy = ChunkProviderErebus.swampWaterHeight;
            this.zz = this.z + this.offsetXZ();
            BlockPos pos2 = new BlockPos(this.xx, this.yy, this.zz);
            this.genReed.func_180709_b(this.world, this.rand, pos2);
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 30) {
            this.xx = this.x + this.offsetXZ();
            this.yy = ChunkProviderErebus.swampWaterHeight - 4;
            this.zz = this.z + this.offsetXZ();
            BlockPos pos3 = new BlockPos(this.xx, this.yy, this.zz);
            this.genVines.func_180709_b(this.world, this.rand, pos3);
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = ChunkProviderErebus.swampWaterHeight + this.rand.nextInt(36 - ChunkProviderErebus.swampWaterHeight);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos4 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.world.func_175623_d(pos4)) {
                this.genMossPatch.func_180709_b(this.world, this.rand, pos4);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 240) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                BlockPos pos5 = new BlockPos(this.xx, this.yy, this.zz);
                if (this.world.func_180495_p(pos5) == Blocks.field_150349_c.func_176223_P() && this.world.func_175623_d(pos5.func_177984_a())) {
                    if (this.rand.nextInt(3) != 0) break;
                    this.world.func_180501_a(pos5, ModBlocks.MUD.func_176223_P(), 2);
                    break;
                }
                this.yy += this.rand.nextInt(2) + 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 600) {
            this.xx = this.x + this.rand.nextInt(5) + 12;
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.rand.nextInt(5) + 12;
            BlockPos pos6 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos6) && this.checkSurface(SurfaceType.GRASS, pos6.func_177965_g(2)) && this.checkSurface(SurfaceType.GRASS, pos6.func_177985_f(2)) && this.checkSurface(SurfaceType.GRASS, pos6.func_177964_d(2)) && this.checkSurface(SurfaceType.GRASS, pos6.func_177970_e(2))) {
                this.genTreeMarshwood.func_180709_b(this.world, this.rand, pos6.func_177984_a());
            }
            ++this.attempt;
        }
        if (this.rand.nextBoolean()) {
            this.attempt = 0;
            while (this.attempt < 50) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 20 + this.rand.nextInt(80);
                this.zz = this.z + this.offsetXZ();
                BlockPos pos7 = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos7)) {
                    this.genTreeMossbark.func_180709_b(this.world, this.rand, pos7.func_177984_a());
                    break;
                }
                ++this.attempt;
            }
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 30 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos8 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.world.func_175623_d(pos8)) {
                this.genMossPatch.func_180709_b(this.world, this.rand, pos8);
            }
            ++this.attempt;
        }
        if (ConfigHandler.INSTANCE.generateVents && this.rand.nextBoolean()) {
            this.attempt = 0;
            while (this.attempt < this.rand.nextInt(4)) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 25 + this.rand.nextInt(75);
                this.zz = this.z + this.offsetXZ();
                while (this.yy > 20) {
                    BlockPos pos9 = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos9)) {
                        this.genGasVent.func_180709_b(this.world, this.rand, pos9);
                        break;
                    }
                    --this.yy;
                }
                ++this.attempt;
            }
        }
        if (this.rand.nextInt(10) == 0) {
            this.attempt = 0;
            while (this.attempt < this.rand.nextInt(4)) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 25 + this.rand.nextInt(75);
                this.zz = this.z + this.offsetXZ();
                while (this.yy > 20) {
                    BlockPos pos10 = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos10)) {
                        this.genSwampBush.func_180709_b(this.world, this.rand, pos10.func_177984_a());
                        break;
                    }
                    if (this.checkSurface(SurfaceType.UMBERSTONE, pos10) && this.world.func_175623_d(pos10.func_177984_a())) {
                        this.genSwampBush.func_180709_b(this.world, this.rand, pos10.func_177984_a());
                        break;
                    }
                    --this.yy;
                }
                ++this.attempt;
            }
        }
        this.attempt = 0;
        while (this.attempt < 8) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos11 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos11) && this.world.func_175623_d(pos11.func_177984_a()) && this.world.func_175623_d(pos11.func_177981_b(2))) {
                ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos11.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.SUNDEW, 2);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < this.rand.nextInt(3)) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 20 + this.rand.nextInt(25) * (1 + this.rand.nextInt(3));
            this.zz = this.z + this.offsetXZ();
            BlockPos pos12 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.MIXED, pos12)) {
                this.genRottenAcacia.func_180709_b(this.world, this.rand, pos12.func_177984_a());
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 800) {
            int offset;
            this.xx = this.x + this.offsetXZ();
            this.yy = 30 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.world.func_175623_d(pos) && this.world.func_180495_p(new BlockPos(this.xx + offsetX[offset = this.rand.nextInt(4)], this.yy, this.zz + offsetZ[offset])).func_185915_l()) {
                for (int vineY = this.rand.nextInt(30); vineY > 0; --vineY) {
                    if (!this.world.func_175623_d(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]))) continue;
                    if (offset == 3) {
                        this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)), 3);
                    }
                    if (offset == 2) {
                        this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)), 3);
                    }
                    if (offset == 1) {
                        this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 3);
                    }
                    if (offset != 0) continue;
                    this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 20) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos)) {
                    if (this.rand.nextInt(10) == 0 && this.world.func_175623_d(pos.func_177981_b(2))) {
                        Blocks.field_150398_cm.func_176491_a(this.world, pos.func_177984_a(), BlockDoublePlant.EnumPlantType.FERN, 2);
                        break;
                    }
                    if (!this.world.func_175623_d(pos.func_177984_a())) break;
                    this.world.func_180501_a(pos.func_177984_a(), ModBlocks.SMALL_PLANT.func_176223_P().func_177226_a(BlockSmallPlant.PLANT_TYPE, (Comparable)((Object)BlockSmallPlant.EnumSmallPlantType.FERN)), 2);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 16) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos) && this.world.func_175623_d(pos.func_177984_a())) {
                    this.world.func_180501_a(pos.func_177984_a(), ModBlocks.SMALL_PLANT.func_176223_P().func_177226_a(BlockSmallPlant.PLANT_TYPE, (Comparable)((Object)BlockSmallPlant.EnumSmallPlantType.FIDDLE_HEAD)), 2);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 40) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos) && this.world.func_175623_d(pos.func_177984_a())) {
                    this.world.func_180501_a(pos.func_177984_a(), ModBlocks.SMALL_PLANT.func_176223_P().func_177226_a(BlockSmallPlant.PLANT_TYPE, (Comparable)((Object)BlockSmallPlant.EnumSmallPlantType.SWAMP_PLANT)), 2);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 10) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genQuickSand.func_180709_b(this.world, this.rand, pos);
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 40) {
            int length = this.rand.nextInt(5) + 4;
            int baseRadius = this.rand.nextInt(3) + 2;
            byte direction = (byte)this.rand.nextInt(2);
            this.xx = this.x + 16;
            this.yy = this.rand.nextInt(118);
            this.zz = this.z + 16;
            BlockPos pos13 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos13)) {
                new WorldGenRottenLogs(length, baseRadius, direction).func_180709_b(this.world, this.rand, pos13.func_177984_a());
            }
            ++this.attempt;
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case COAL: {
                oreGen.setChance(0.85f).setIterations(extraOres ? 2 : 3).setOreAmount(7, 10).setY(5, 56);
                break;
            }
            case EMERALD: {
                oreGen.setIterations(1, 3);
                break;
            }
            case DIAMOND: {
                oreGen.setIterations(3, 4);
                break;
            }
            case PETRIFIED_WOOD: {
                oreGen.setIterations(extraOres ? 1 : 2, extraOres ? 2 : 3).setY(20, 64).setCheckArea(3);
                break;
            }
            case FOSSIL: {
                oreGen.setChance(0.25f);
            }
        }
    }

    @Override
    public void generateFeature(FeatureType featureType) {
        if (featureType == FeatureType.RED_GEM) {
            this.attempt = 0;
            while (this.attempt < 8) {
                genRedGem.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), 64 + this.rand.nextInt(60), this.z + this.offsetXZ()));
                ++this.attempt;
            }
        } else {
            super.generateFeature(featureType);
        }
    }
}

