/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.ModBlocks;
import erebus.blocks.BlockDustLayer;
import erebus.blocks.BlockHangingWeb;
import erebus.blocks.BlockMandrake;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.FeatureType;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenRockSpike;
import erebus.world.feature.decoration.WorldGenScorchedWood;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldGenLakes;

public class BiomeDecoratorPetrifiedForest
extends BiomeDecoratorBaseErebus {
    private final WorldGenScorchedWood genScorchedWood = new WorldGenScorchedWood();
    private final WorldGenLakes genLavaLakes = new WorldGenLakes(ModBlocks.FORMIC_ACID);
    private final WorldGenRockSpike rockSpike = new WorldGenRockSpike();
    private static final int[] offsetX = new int[]{-1, 1, 0, 0};
    private static final int[] offsetZ = new int[]{0, 0, -1, 1};

    @Override
    public void populate() {
        this.attempt = 0;
        while (this.attempt < 35) {
            this.xx = this.x + this.offsetXZ();
            this.yy = 15 + this.rand.nextInt(90);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.VOLCANIC_ROCK, pos)) {
                this.genLavaLakes.func_180709_b(this.world, this.world.field_73012_v, pos.func_177984_a());
            }
            ++this.attempt;
        }
    }

    @Override
    public void decorate() {
        BlockPos pos;
        this.attempt = 0;
        while (this.attempt < 240) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.world.func_180495_p(pos) == ModBlocks.VOLCANIC_ROCK.func_176223_P() && this.world.func_175623_d(pos.func_177984_a())) {
                    if (this.rand.nextInt(3) == 0) {
                        this.world.func_180501_a(pos, ModBlocks.UMBERGRAVEL.func_176223_P(), 2);
                    }
                    if (this.rand.nextInt(3) != 0) break;
                    this.world.func_180501_a(pos, ModBlocks.DUST.func_176223_P(), 2);
                    break;
                }
                this.yy += this.rand.nextInt(2) + 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 3) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(100);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            this.rockSpike.func_180709_b(this.world, this.rand, pos.func_177984_a());
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 240) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if ((this.world.func_180495_p(pos) == ModBlocks.VOLCANIC_ROCK.func_176223_P() || this.world.func_180495_p(pos) == ModBlocks.PETRIFIED_WOOD_ROCK.func_176223_P()) && this.world.func_175623_d(pos.func_177984_a())) {
                    this.world.func_180501_a(pos.func_177984_a(), ModBlocks.DUST_LAYER.func_176223_P().func_177226_a((IProperty)BlockDustLayer.LAYERS, (Comparable)Integer.valueOf(this.rand.nextInt(3) + 1)), 2);
                    break;
                }
                this.yy += this.rand.nextInt(2) + 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 5) {
            this.xx = this.x + this.offsetXZ();
            this.zz = this.z + this.offsetXZ();
            this.yy = 20;
            while (this.yy < 100) {
                pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.DUST, pos) && this.world.func_175623_d(pos.func_177984_a())) {
                    this.world.func_180501_a(pos.func_177984_a(), ModBlocks.CROP_MANDRAKE.func_176223_P().func_177226_a((IProperty)BlockMandrake.field_176488_a, (Comparable)Integer.valueOf(this.rand.nextInt(8))), 2);
                    break;
                }
                this.yy += this.rand.nextBoolean() ? 2 : 1;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 22) {
            this.xx = this.x + this.offsetXZ();
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + this.offsetXZ();
            pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.VOLCANIC_ROCK, pos) && !this.world.func_175623_d(pos.func_177979_c(2))) {
                this.genScorchedWood.func_180709_b(this.world, this.rand, pos);
                if (this.rand.nextInt(4) != 0) break;
            }
            ++this.attempt;
        }
        this.attempt = 0;
        while (this.attempt < 800) {
            int offset;
            this.xx = this.x + this.offsetXZ();
            this.yy = 30 + this.rand.nextInt(80);
            this.zz = this.z + this.offsetXZ();
            BlockPos pos2 = new BlockPos(this.xx, this.yy, this.zz);
            if (this.world.func_175623_d(pos2) && this.world.func_180495_p(new BlockPos(this.xx + offsetX[offset = this.rand.nextInt(4)], this.yy, this.zz + offsetZ[offset])).func_185915_l()) {
                for (int vineY = this.rand.nextInt(30); vineY > 0; --vineY) {
                    if (!this.world.func_175623_d(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]))) continue;
                    if (offset == 3) {
                        this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), ModBlocks.HANGING_WEB.func_176223_P().func_177226_a((IProperty)BlockHangingWeb.field_176279_N, (Comparable)Boolean.valueOf(true)), 2);
                    }
                    if (offset == 2) {
                        this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), ModBlocks.HANGING_WEB.func_176223_P().func_177226_a((IProperty)BlockHangingWeb.field_176273_b, (Comparable)Boolean.valueOf(true)), 2);
                    }
                    if (offset == 1) {
                        this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), ModBlocks.HANGING_WEB.func_176223_P().func_177226_a((IProperty)BlockHangingWeb.field_176278_M, (Comparable)Boolean.valueOf(true)), 2);
                    }
                    if (offset != 0) continue;
                    this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), ModBlocks.HANGING_WEB.func_176223_P().func_177226_a((IProperty)BlockHangingWeb.field_176280_O, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
            ++this.attempt;
        }
    }

    @Override
    public void generateFeature(FeatureType featureType) {
        if (featureType == FeatureType.RED_GEM) {
            this.attempt = 0;
            while (this.attempt < 10) {
                genRedGem.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(64), this.z + this.offsetXZ()));
                ++this.attempt;
            }
        } else {
            super.generateFeature(featureType);
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case COAL: {
                oreGen.setChance(0.0f);
                break;
            }
            case GOLD: {
                oreGen.setIterations(extraOres ? 1 : 2, extraOres ? 2 : 3);
                break;
            }
            case DIAMOND: {
                oreGen.setType(OreSettings.OreType.DIAMOND_ENCRUSTED).setChance(0.4f).setIterations(1, 2).setOreAmount(2).setY(5, 16);
                break;
            }
            case JADE: {
                oreGen.setIterations(0, 2);
                break;
            }
            case FOSSIL: {
                oreGen.setChance(0.25f).setIterations(0, 1);
            }
        }
    }
}

