/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.recipes.SmoothieMakerRecipe;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntitySmoothieMaker
extends TileEntityBasicInventory
implements ITickable {
    private static final int MAX_TIME = 432;
    private IItemHandler itemHandler;
    private final FluidTank[] tanks = new FluidTank[4];
    private int progress = 0;
    private int prevProgress = 0;

    public TileEntitySmoothieMaker() {
        super(5, "container.kitchenCounter");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(16000);
        }
    }

    public FluidTank[] getTanks() {
        return this.tanks;
    }

    public float getBlendProgress() {
        return (float)this.progress / 12.0f;
    }

    public float getPrevBlendProgress() {
        return (float)this.prevProgress / 12.0f;
    }

    public boolean isBlending() {
        return this.progress > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("progress");
        if (nbt.func_74764_b("honeyTank")) {
            this.tanks[0].readFromNBT(nbt.func_74775_l("honeyTank"));
            this.tanks[1].readFromNBT(nbt.func_74775_l("milkTank"));
            this.tanks[2].readFromNBT(nbt.func_74775_l("beetleTank"));
            this.tanks[3].readFromNBT(nbt.func_74775_l("antiVenomTank"));
        } else {
            this.readTanksFromNBT(nbt);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("progress", this.progress);
        this.writeTanksToNBT(nbt);
        return nbt;
    }

    private void writeTanksToNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.tanks.length; ++i) {
            nbt.func_74782_a("tank_" + i, (NBTBase)this.tanks[i].writeToNBT(new NBTTagCompound()));
        }
    }

    private void readTanksFromNBT(NBTTagCompound nbt) {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt.func_74775_l("tank_" + i));
        }
    }

    public void writeGUIData(NBTTagCompound nbt) {
        nbt.func_74768_a("progress", this.progress);
        this.writeTanksToNBT(nbt);
    }

    public void readGUIData(NBTTagCompound nbt) {
        this.progress = nbt.func_74762_e("progress");
        this.readTanksFromNBT(nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        return this.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.prevProgress = this.progress;
            return;
        }
        ItemStack[] inputs = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            inputs[i] = (ItemStack)this.getInventory().get(i);
        }
        SmoothieMakerRecipe recipe = SmoothieMakerRecipe.getRecipe(this.func_70301_a(4), (IFluidTank)this.tanks[0], (IFluidTank)this.tanks[1], (IFluidTank)this.tanks[2], (IFluidTank)this.tanks[3], inputs);
        if (recipe != null) {
            ++this.progress;
            if (this.progress >= 432) {
                for (int i = 0; i < 5; ++i) {
                    if (((ItemStack)this.getInventory().get(i)).func_190926_b()) continue;
                    ((ItemStack)this.getInventory().get(i)).func_190918_g(1);
                }
                this.extractFluids(recipe);
                this.getInventory().set(4, (Object)recipe.getOutput().func_77946_l());
                this.progress = 0;
                this.func_70296_d();
            }
        }
        if (recipe == null || this.func_70301_a(4).func_190926_b() || this.func_70301_a(4).func_190916_E() > 1) {
            this.progress = 0;
            this.func_70296_d();
        }
    }

    private void extractFluids(SmoothieMakerRecipe recipe) {
        block0: for (FluidStack fluid : recipe.getFluids()) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() == null || !tank.getFluid().isFluidEqual(fluid)) continue;
                tank.drain(fluid.amount, true);
                continue block0;
            }
        }
    }

    @Override
    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            FluidTank[] myTanks = this.getTanks();
            return (T)new IFluidHandler((IFluidHandler[])myTanks){
                final /* synthetic */ IFluidHandler[] val$myTanks;
                {
                    this.val$myTanks = iFluidHandlerArray;
                }

                public IFluidTankProperties[] getTankProperties() {
                    IFluidTankProperties[] infos = new IFluidTankProperties[TileEntitySmoothieMaker.this.tanks.length];
                    for (int i = 0; i < TileEntitySmoothieMaker.this.tanks.length; ++i) {
                        infos[i] = new FluidTankPropertiesWrapper(TileEntitySmoothieMaker.this.tanks[i]);
                    }
                    return infos;
                }

                public int fill(FluidStack resource, boolean doFill) {
                    for (IFluidHandler tank : this.val$myTanks) {
                        int filled = tank.fill(resource, doFill);
                        if (filled == 0) continue;
                        return filled;
                    }
                    return 0;
                }

                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    for (IFluidHandler tank : this.val$myTanks) {
                        FluidStack ret = tank.drain(resource, doDrain);
                        if (ret == null || ret.amount == 0) continue;
                        return ret;
                    }
                    return null;
                }

                public FluidStack drain(int maxDrain, boolean doDrain) {
                    for (IFluidHandler tank : this.val$myTanks) {
                        FluidStack ret = tank.drain(maxDrain, doDrain);
                        if (ret == null || ret.amount == 0) continue;
                        return ret;
                    }
                    return null;
                }
            };
        }
        return super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] SLOTS = new int[this.func_70302_i_()];
        for (int index = 0; index < SLOTS.length; ++index) {
            SLOTS[index] = index;
        }
        return SLOTS;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 4;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

