/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.ModBlocks;
import erebus.block.bamboo.BlockBambooBridge;
import erebus.block.bamboo.BlockExtenderThingy;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityExtenderThingy
extends TileEntityBasicInventory
implements ITickable {
    private boolean extending;
    private EnumFacing direction;
    private IItemHandler itemHandler;

    public TileEntityExtenderThingy() {
        super(6, "container.extenderThingy");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        Block blockID;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (this.direction == null) {
            this.direction = (EnumFacing)state.func_177229_b((IProperty)BlockExtenderThingy.field_176387_N);
        }
        Block extension = this.getExtension(this.direction);
        int index = this.getIndex(extension);
        if (this.extending) {
            blockID = extension;
        } else {
            blockID = null;
            --index;
        }
        int x = this.func_174877_v().func_177958_n() + index * this.direction.func_82601_c();
        int y = this.func_174877_v().func_177956_o() + index * this.direction.func_96559_d();
        int z = this.func_174877_v().func_177952_p() + index * this.direction.func_82599_e();
        if (x == this.func_174877_v().func_177958_n() && y == this.func_174877_v().func_177956_o() && z == this.func_174877_v().func_177952_p()) {
            return;
        }
        if ((state.func_177230_c() == null || state.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), new BlockPos(x, y, z)) || !this.extending) && this.decreaseInventory(blockID) && this.addToInventory(new BlockPos(x, y, z))) {
            if (this.extending) {
                this.func_145831_w().func_180501_a(new BlockPos(x, y, z), this.getStateFromDirection(this.direction), 3);
                this.func_145831_w().func_184133_a((EntityPlayer)null, new BlockPos(x, y, z), extension.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, (extension.func_185467_w().func_185843_a() + 1.0f) / 2.0f, extension.func_185467_w().func_185847_b() * 0.8f);
            } else {
                this.func_145831_w().func_175698_g(new BlockPos(x, y, z));
                this.func_145831_w().func_180498_a((EntityPlayer)null, 2001, new BlockPos(x, y, z), Block.func_149682_b((Block)extension));
            }
        }
    }

    private int getIndex(Block extension) {
        int index = 1;
        int x = this.func_174877_v().func_177958_n() + index * this.direction.func_82601_c();
        int y = this.func_174877_v().func_177956_o() + index * this.direction.func_96559_d();
        int z = this.func_174877_v().func_177952_p() + index * this.direction.func_82599_e();
        while (this.func_145831_w().func_180495_p(new BlockPos(x, y, z)).func_177230_c() == extension) {
            x = this.func_174877_v().func_177958_n() + ++index * this.direction.func_82601_c();
            y = this.func_174877_v().func_177956_o() + index * this.direction.func_96559_d();
            z = this.func_174877_v().func_177952_p() + index * this.direction.func_82599_e();
        }
        IBlockState state = this.func_145831_w().func_180495_p(new BlockPos(x, y, z));
        if (state.func_177230_c() == null || state.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), new BlockPos(x, y, z)) || !this.extending) {
            return index;
        }
        return index - 1;
    }

    private boolean addToInventory(BlockPos pos) {
        IBlockState state = this.func_145831_w().func_180495_p(pos);
        if (this.func_145831_w().func_175623_d(pos) || state.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), pos)) {
            return true;
        }
        for (int i = 0; i < this.getInventory().size(); ++i) {
            if (((ItemStack)this.getInventory().get(i)).func_190926_b()) {
                this.getInventory().set(i, (Object)new ItemStack(state.func_177230_c(), 1, 0));
                return true;
            }
            if (((ItemStack)this.getInventory().get(i)).func_77973_b() != Item.func_150898_a((Block)state.func_177230_c()) || ((ItemStack)this.getInventory().get(i)).func_190916_E() >= ((ItemStack)this.getInventory().get(i)).func_77976_d() || ((ItemStack)this.getInventory().get(i)).func_190916_E() >= this.func_70297_j_()) continue;
            ((ItemStack)this.getInventory().get(i)).func_190917_f(1);
            return true;
        }
        return false;
    }

    private boolean decreaseInventory(Block blockID) {
        if (blockID == null) {
            return true;
        }
        for (int i = 0; i < this.getInventory().size(); ++i) {
            if (((ItemStack)this.getInventory().get(i)).func_190926_b() || ((ItemStack)this.getInventory().get(i)).func_77973_b() != Item.func_150898_a((Block)blockID)) continue;
            ((ItemStack)this.getInventory().get(i)).func_190918_g(1);
            if (((ItemStack)this.getInventory().get(i)).func_190916_E() <= 0) {
                this.getInventory().set(i, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    private Block getExtension(EnumFacing facing) {
        return facing == EnumFacing.UP || facing == EnumFacing.DOWN ? ModBlocks.BAMBOO_NERD_POLE : ModBlocks.BAMBOO_BRIDGE;
    }

    private IBlockState getStateFromDirection(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return ModBlocks.BAMBOO_NERD_POLE.func_176223_P();
            }
            case DOWN: {
                return ModBlocks.BAMBOO_NERD_POLE.func_176223_P();
            }
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return ModBlocks.BAMBOO_BRIDGE.func_176223_P().func_177226_a((IProperty)BlockBambooBridge.FACING, (Comparable)facing);
            }
        }
        return ModBlocks.BAMBOO_BRIDGE.func_176223_P();
    }

    public void setExtending(boolean extending) {
        this.extending = extending;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.BAMBOO_NERD_POLE) || stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.BAMBOO_BRIDGE));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74757_a("extending", this.extending);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.extending = data.func_74767_n("extending");
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] SLOTS = new int[this.func_70302_i_()];
        for (int index = 0; index < SLOTS.length; ++index) {
            SLOTS[index] = index;
        }
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    @Override
    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return super.getCapability(capability, facing);
    }
}

