/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import erebus.ModBlocks;
import erebus.recipes.ComposterRegistry;
import erebus.tileentity.TileEntityBasicInventory;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityComposter
extends TileEntityBasicInventory
implements ITickable {
    public int composterBurnTime;
    public int currentItemBurnTime;
    public int composterCookTime;

    public TileEntityComposter() {
        super(3, "container.composter");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.composterBurnTime = nbt.func_74765_d("BurnTime");
        this.composterCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityComposter.getItemBurnTime((ItemStack)this.getInventory().get(1));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.composterBurnTime);
        nbt.func_74777_a("CookTime", (short)this.composterCookTime);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int cookTime) {
        return this.composterCookTime * cookTime / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int burnTime) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.composterBurnTime * burnTime / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.composterBurnTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.composterBurnTime > 0;
        boolean flag1 = false;
        if (this.composterBurnTime > 0) {
            --this.composterBurnTime;
        }
        if (!this.func_145831_w().field_72995_K) {
            if (this.composterBurnTime != 0 || !((ItemStack)this.getInventory().get(1)).func_190926_b() && !((ItemStack)this.getInventory().get(0)).func_190926_b()) {
                if (this.composterBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.composterBurnTime = TileEntityComposter.getItemBurnTime((ItemStack)this.getInventory().get(1));
                    if (this.composterBurnTime > 0) {
                        flag1 = true;
                        if (!((ItemStack)this.getInventory().get(1)).func_190926_b()) {
                            ((ItemStack)this.getInventory().get(1)).func_190918_g(1);
                            if (((ItemStack)this.getInventory().get(1)).func_190916_E() == 0) {
                                this.getInventory().set(1, (Object)((ItemStack)this.getInventory().get(1)).func_77973_b().getContainerItem((ItemStack)this.getInventory().get(1)));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.composterCookTime;
                    if (this.composterCookTime == 200) {
                        this.composterCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.composterCookTime = 0;
                }
            }
            if (flag != this.composterBurnTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (((ItemStack)this.getInventory().get(0)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = ComposterRegistry.isCompostable((ItemStack)this.getInventory().get(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.getInventory().get(2)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.getInventory().get(2)).func_77969_a(itemstack)) {
            return false;
        }
        int result = ((ItemStack)this.getInventory().get(2)).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= ((ItemStack)this.getInventory().get(2)).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = ComposterRegistry.isCompostable((ItemStack)this.getInventory().get(0));
            if (((ItemStack)this.getInventory().get(2)).func_190926_b()) {
                this.getInventory().set(2, (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.getInventory().get(2)).func_77973_b() == itemstack.func_77973_b()) {
                ((ItemStack)this.getInventory().get(2)).func_190917_f(itemstack.func_190916_E());
            }
            ((ItemStack)this.getInventory().get(0)).func_190918_g(1);
            if (((ItemStack)this.getInventory().get(0)).func_190916_E() <= 0) {
                this.getInventory().set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static int getItemBurnTime(ItemStack is) {
        if (is.func_190926_b()) {
            return 0;
        }
        Item item = is.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == ModBlocks.WALL_PLANTS && is.func_77952_i() == 7) {
                return 800;
            }
            if (block == ModBlocks.WALL_PLANTS_CULTIVATED && is.func_77952_i() == 7) {
                return 400;
            }
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack is) {
        return TileEntityComposter.getItemBurnTime(is) > 0;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 2 ? false : (slot == 1 ? TileEntityComposter.isItemFuel(is) : true);
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }
}

