/*
 * Decompiled with CFR 0.152.
 */
package erebus.recipes;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.blocks.BlockGiantFlower;
import erebus.blocks.EnumWood;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import erebus.recipes.RecipeGliderDye;
import erebus.recipes.RecipePaxel;
import erebus.recipes.RecipeSprintLeggingsUpgrades;
import erebus.world.biomes.decorators.data.OreSettings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeHandler {
    public static final List<IRecipe> RECIPES = new ArrayList<IRecipe>();
    public static final IRecipe RECIPE_PAXEL = new RecipePaxel();
    public static final IRecipe GLIDER_DYE = new RecipeGliderDye();
    public static final IRecipe LEGGINGS_UPGRADES = new RecipeSprintLeggingsUpgrades();

    private static ResourceLocation getResource(String inName) {
        return new ResourceLocation("erebus", inName);
    }

    public static void init() {
        try {
            for (Field field : RecipeHandler.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof IRecipe)) continue;
                IRecipe recipe = (IRecipe)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                RecipeHandler.registerRecipe(name, recipe);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerRecipe(String inName, IRecipe recipe) {
        RECIPES.add(recipe);
        recipe.setRegistryName(RecipeHandler.getResource(inName));
    }

    public static void registerSmelting() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.AMBER), (ItemStack)new ItemStack(ModBlocks.AMBER_GLASS, 1, 0), (float)0.3f);
        GameRegistry.addSmelting((ItemStack)ItemErebusFood.EnumFoodType.BEETLE_LARVA_RAW.createStack(), (ItemStack)ItemErebusFood.EnumFoodType.BEETLE_LARVA_COOKED.createStack(), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)ItemErebusFood.EnumFoodType.GRASSHOPPER_LEG_RAW.createStack(), (ItemStack)ItemErebusFood.EnumFoodType.GRASSHOPPER_LEG_COOKED.createStack(), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)ItemErebusFood.EnumFoodType.TARANTULA_LEG_RAW.createStack(), (ItemStack)ItemErebusFood.EnumFoodType.TARANTULA_LEG_COOKED.createStack(), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)ItemErebusFood.EnumFoodType.TITAN_CHOP_RAW.createStack(), (ItemStack)ItemErebusFood.EnumFoodType.TITAN_CHOP_COOKED.createStack(), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)ItemErebusFood.EnumFoodType.PRICKLY_PEAR_RAW.createStack(), (ItemStack)ItemErebusFood.EnumFoodType.PRICKLY_PEAR_COOKED.createStack(), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.UMBERSTONE, 1, 1), (ItemStack)new ItemStack(ModBlocks.UMBERSTONE), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_COAL), (ItemStack)new ItemStack(Items.field_151044_h, 1), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_IRON), (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_GOLD), (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_LAPIS), (ItemStack)new ItemStack(Items.field_151100_aR, 1, 4), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_DIAMOND), (ItemStack)new ItemStack(Items.field_151045_i), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_EMERALD), (ItemStack)new ItemStack(Items.field_151166_bC), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_JADE), (ItemStack)ItemMaterials.EnumErebusMaterialsType.JADE.createStack(), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_FOSSIL), (ItemStack)ItemMaterials.EnumErebusMaterialsType.SHARD_BONE.createStack(), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_GNEISS), (ItemStack)ItemMaterials.EnumErebusMaterialsType.GNEISS_ROCK.createStack(), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_PETRIFIED_WOOD), (ItemStack)ItemMaterials.EnumErebusMaterialsType.PETRIFIED_WOOD.createStack(), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_ENCRUSTED_DIAMOND), (ItemStack)new ItemStack(Items.field_151045_i, 2), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)ItemMaterials.EnumErebusMaterialsType.TITAN_STEW.createStack(), (ItemStack)ItemErebusFood.EnumFoodType.TITAN_STEW_COOKED.createStack(), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModItems.STAG_HEART_RAW), (ItemStack)new ItemStack(ModItems.STAG_HEART_COOKED), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.MUD), (ItemStack)ItemMaterials.EnumErebusMaterialsType.MUD_BRICK.createStack(), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)ItemMaterials.EnumErebusMaterialsType.NECTAR.createStack(), (ItemStack)ItemMaterials.EnumErebusMaterialsType.HONEY_DRIP.createStack(), (float)0.2f);
        if (OreSettings.OreType.LEAD.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_LEAD), (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_LEAD.createStack(), (float)1.0f);
        }
        if (OreSettings.OreType.SILVER.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_SILVER), (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_SILVER.createStack(), (float)1.0f);
        }
        if (OreSettings.OreType.COPPER.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_COPPER), (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_COPPER.createStack(), (float)1.0f);
        }
        if (OreSettings.OreType.TIN.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_TIN), (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_TIN.createStack(), (float)1.0f);
        }
        if (OreSettings.OreType.ALUMINIUM.isEnabled()) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(ModBlocks.ORE_ALUMINIUM), (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_ALUMINIUM.createStack(), (float)1.0f);
        }
        for (EnumWood wood : EnumWood.values()) {
            if (!wood.hasLog()) continue;
            Block log = wood.getLog();
            GameRegistry.addSmelting((ItemStack)new ItemStack(log), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
    }

    @Mod.EventBusSubscriber(modid="erebus")
    public static class RegistrationHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerOreDictEntries(RegistryEvent.Register<Item> event) {
            OreDictionary.registerOre((String)"chestWood", (ItemStack)new ItemStack((Block)Blocks.field_150486_ae));
            OreDictionary.registerOre((String)"buttonWood", (ItemStack)new ItemStack(Blocks.field_150471_bO));
            OreDictionary.registerOre((String)"fenceWood", (ItemStack)new ItemStack(Blocks.field_180407_aO));
            OreDictionary.registerOre((String)"oreCoal", (ItemStack)new ItemStack(ModBlocks.ORE_COAL));
            OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(ModBlocks.ORE_IRON));
            OreDictionary.registerOre((String)"oreGold", (ItemStack)new ItemStack(ModBlocks.ORE_GOLD));
            OreDictionary.registerOre((String)"oreLapis", (ItemStack)new ItemStack(ModBlocks.ORE_LAPIS));
            OreDictionary.registerOre((String)"oreDiamond", (ItemStack)new ItemStack(ModBlocks.ORE_DIAMOND));
            OreDictionary.registerOre((String)"oreEmerald", (ItemStack)new ItemStack(ModBlocks.ORE_EMERALD));
            OreDictionary.registerOre((String)"oreJade", (ItemStack)new ItemStack(ModBlocks.ORE_JADE));
            OreDictionary.registerOre((String)"orePetrifiedWood", (ItemStack)new ItemStack(ModBlocks.ORE_PETRIFIED_WOOD));
            OreDictionary.registerOre((String)"oreDiamond", (ItemStack)new ItemStack(ModBlocks.ORE_ENCRUSTED_DIAMOND));
            OreDictionary.registerOre((String)"oreFossil", (ItemStack)new ItemStack(ModBlocks.ORE_FOSSIL));
            OreDictionary.registerOre((String)"oreGneiss", (ItemStack)new ItemStack(ModBlocks.ORE_GNEISS));
            OreDictionary.registerOre((String)"oreQuartz", (ItemStack)new ItemStack(ModBlocks.ORE_QUARTZ));
            OreDictionary.registerOre((String)"cobblestone", (ItemStack)new ItemStack(ModBlocks.UMBERSTONE, 1, 1));
            OreDictionary.registerOre((String)"stone", (ItemStack)new ItemStack(ModBlocks.UMBERSTONE));
            OreDictionary.registerOre((String)"stoneUmber", (ItemStack)new ItemStack(ModBlocks.UMBERSTONE));
            OreDictionary.registerOre((String)"gemJade", (ItemStack)ItemMaterials.EnumErebusMaterialsType.JADE.createStack());
            OreDictionary.registerOre((String)"blockJade", (ItemStack)new ItemStack(ModBlocks.JADE_BLOCK));
            OreDictionary.registerOre((String)"blockSpawner", (Block)ModBlocks.SPIDER_SPAWNER);
            OreDictionary.registerOre((String)"blockSpawner", (Block)ModBlocks.JUMPING_SPIDER_SPAWNER);
            OreDictionary.registerOre((String)"blockSpawner", (Block)ModBlocks.WASP_SPAWNER);
            OreDictionary.registerOre((String)"blockGlass", (ItemStack)new ItemStack(ModBlocks.AMBER_GLASS, 1, 0));
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(EnumWood.BALSAM.getLog()));
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(EnumWood.SCORCHED.getLog()));
            OreDictionary.registerOre((String)"bamboo", (ItemStack)ItemMaterials.EnumErebusMaterialsType.BAMBOO.createStack());
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ModBlocks.PLANKS, 1, Short.MAX_VALUE));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(ModBlocks.PLANKS));
            OreDictionary.registerOre((String)"plankPetrified", (ItemStack)new ItemStack(ModBlocks.PLANKS_PETRIFIED_WOOD));
            for (EnumWood wood : EnumWood.values()) {
                OreDictionary.registerOre((String)("plank" + wood.func_176610_l().toUpperCase().charAt(0) + wood.func_176610_l().substring(1)), (ItemStack)new ItemStack(ModBlocks.PLANKS, 1, wood.ordinal()));
            }
            OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_BLACK.ordinal()));
            OreDictionary.registerOre((String)"dyeRed", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_RED.ordinal()));
            OreDictionary.registerOre((String)"dyeBrown", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_BROWN.ordinal()));
            OreDictionary.registerOre((String)"dyeBlue", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_BLUE.ordinal()));
            OreDictionary.registerOre((String)"dyePurple", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_PURPLE.ordinal()));
            OreDictionary.registerOre((String)"dyeCyan", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_CYAN.ordinal()));
            OreDictionary.registerOre((String)"dyeLightGray", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_LIGHT_GRAY.ordinal()));
            OreDictionary.registerOre((String)"dyeGray", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_GRAY.ordinal()));
            OreDictionary.registerOre((String)"dyePink", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_PINK.ordinal()));
            OreDictionary.registerOre((String)"dyeYellow", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_YELLOW.ordinal()));
            OreDictionary.registerOre((String)"dyeLightBlue", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_LIGHT_BLUE.ordinal()));
            OreDictionary.registerOre((String)"dyeMagenta", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_MAGENTA.ordinal()));
            OreDictionary.registerOre((String)"dyeOrange", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_ORANGE.ordinal()));
            OreDictionary.registerOre((String)"dyeWhite", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.PETAL_WHITE.ordinal()));
            OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack(ModBlocks.GIANT_FLOWER, 1, BlockGiantFlower.EnumType.STEM.ordinal()));
            OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack(ModBlocks.GIANT_LILY_PAD, 1, 0));
            OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.DARK_CAPPED_MUSHROOM));
            OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.KAIZERS_FINGERS_MUSHROOM));
            OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.SARCASTIC_CZECH_MUSHROOM));
            OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.GRANDMAS_SHOES_MUSHROOM));
            OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack(ModBlocks.DUTCH_CAP_MUSHROOM));
            OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack((Block)Blocks.field_150337_Q));
            OreDictionary.registerOre((String)"foodMushroom", (ItemStack)new ItemStack((Block)Blocks.field_150338_P));
            OreDictionary.registerOre((String)"dropHoney", (ItemStack)ItemMaterials.EnumErebusMaterialsType.HONEY_DRIP.createStack());
            if (OreSettings.OreType.LEAD.isEnabled()) {
                OreDictionary.registerOre((String)"ingotLead", (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_LEAD.createStack());
                OreDictionary.registerOre((String)"oreLead", (ItemStack)new ItemStack(ModBlocks.ORE_LEAD));
            }
            if (OreSettings.OreType.SILVER.isEnabled()) {
                OreDictionary.registerOre((String)"ingotSilver", (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_SILVER.createStack());
                OreDictionary.registerOre((String)"oreSilver", (ItemStack)new ItemStack(ModBlocks.ORE_SILVER));
            }
            if (OreSettings.OreType.COPPER.isEnabled()) {
                OreDictionary.registerOre((String)"ingotCopper", (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_COPPER.createStack());
                OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(ModBlocks.ORE_COPPER));
            }
            if (OreSettings.OreType.TIN.isEnabled()) {
                OreDictionary.registerOre((String)"ingotTin", (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_TIN.createStack());
                OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(ModBlocks.ORE_TIN));
            }
            if (OreSettings.OreType.ALUMINIUM.isEnabled()) {
                OreDictionary.registerOre((String)"ingotAluminium", (ItemStack)ItemMaterials.EnumErebusMaterialsType.INGOT_ALUMINIUM.createStack());
                OreDictionary.registerOre((String)"oreAluminum", (ItemStack)new ItemStack(ModBlocks.ORE_ALUMINIUM));
            }
            for (EnumWood wood : EnumWood.values()) {
                if (wood.hasLog()) {
                    Block log = wood.getLog();
                    OreDictionary.registerOre((String)"logWood", (Block)log);
                }
                if (wood.hasSapling()) {
                    OreDictionary.registerOre((String)"treeSapling", (Block)wood.getSapling());
                }
                if (wood.hasPlanks()) {
                    Block stairs = wood.getStairs();
                    OreDictionary.registerOre((String)"stairWood", (Block)stairs);
                    Block slab = wood.getSlab();
                    OreDictionary.registerOre((String)"slabWood", (Block)slab);
                }
                if (!wood.hasLeaves()) continue;
                OreDictionary.registerOre((String)"treeLeaves", (Block)wood.getLeaves());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="erebus")
    public static class RegistrationHandlerRecipes {
        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            RecipeHandler.init();
            IForgeRegistry registry = event.getRegistry();
            for (IRecipe recipes : RECIPES) {
                registry.register((IForgeRegistryEntry)recipes);
            }
        }
    }
}

