/*
 * Decompiled with CFR 0.152.
 */
package erebus.proxy;

import erebus.block.silo.TileEntitySiloTank;
import erebus.blocks.BlockPetrifiedChest;
import erebus.entity.EntityAnimatedBambooCrate;
import erebus.entity.EntityBlackAnt;
import erebus.inventory.ContainerAnimatedBambooCrate;
import erebus.inventory.ContainerAntInventory;
import erebus.inventory.ContainerBambooCrate;
import erebus.inventory.ContainerColossalCrate;
import erebus.inventory.ContainerComposter;
import erebus.inventory.ContainerExtenderThingy;
import erebus.inventory.ContainerHoneyComb;
import erebus.inventory.ContainerLiquifier;
import erebus.inventory.ContainerPetrifiedCraftingTable;
import erebus.inventory.ContainerPetrifiedWoodChest;
import erebus.inventory.ContainerSilo;
import erebus.inventory.ContainerSmoothieMaker;
import erebus.inventory.ContainerUmberFurnace;
import erebus.tileentity.TileEntityBambooBridge;
import erebus.tileentity.TileEntityBambooCrate;
import erebus.tileentity.TileEntityBambooPipe;
import erebus.tileentity.TileEntityBambooPipeExtract;
import erebus.tileentity.TileEntityBones;
import erebus.tileentity.TileEntityComposter;
import erebus.tileentity.TileEntityErebusAltar;
import erebus.tileentity.TileEntityErebusAltarEmpty;
import erebus.tileentity.TileEntityErebusAltarHealing;
import erebus.tileentity.TileEntityErebusAltarLightning;
import erebus.tileentity.TileEntityErebusAltarRepair;
import erebus.tileentity.TileEntityErebusAltarXP;
import erebus.tileentity.TileEntityExtenderThingy;
import erebus.tileentity.TileEntityFluidJar;
import erebus.tileentity.TileEntityGaeanKeystone;
import erebus.tileentity.TileEntityGlowingJar;
import erebus.tileentity.TileEntityHoneyComb;
import erebus.tileentity.TileEntityLiquifier;
import erebus.tileentity.TileEntityOfferingAltar;
import erebus.tileentity.TileEntityPetrifiedWoodChest;
import erebus.tileentity.TileEntityPreservedBlock;
import erebus.tileentity.TileEntitySmoothieMaker;
import erebus.tileentity.TileEntityTempleTeleporter;
import erebus.tileentity.TileEntityUmberFurnace;
import erebus.tileentity.TileEntityUmberGolemStatue;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy
implements IGuiHandler {
    public final int[][] places = new int[][]{{1, 0, 0}, {1, 0, 1}, {0, 0, 1}, {1, 1, 0}, {1, 1, 1}, {0, 1, 1}, {0, 1, 0}, {0, 0, 0}};

    public void registerKeyHandlers() {
    }

    public void registerItemAndBlockRenderers() {
    }

    public void setCustomStateMap(Block block, StateMap stateMap) {
    }

    public void postInit() {
    }

    public void registerItemAndBlockColourRenderers() {
    }

    public void registerTileEntities() {
        this.registerTileEntity(TileEntityGaeanKeystone.class, "gaean_keystone");
        this.registerTileEntity(TileEntityBambooCrate.class, "bamboo_crate");
        this.registerTileEntity(TileEntityUmberFurnace.class, "umber_furnace");
        this.registerTileEntity(TileEntityErebusAltar.class, "altar_of_crafting");
        this.registerTileEntity(TileEntityErebusAltarEmpty.class, "altar_empty");
        this.registerTileEntity(TileEntityErebusAltarHealing.class, "altar_of_healing");
        this.registerTileEntity(TileEntityErebusAltarLightning.class, "altar_of_lighting");
        this.registerTileEntity(TileEntityErebusAltarRepair.class, "altar_of_repair");
        this.registerTileEntity(TileEntityErebusAltarXP.class, "altar_of_xp");
        this.registerTileEntity(TileEntityGlowingJar.class, "glowing_jar");
        this.registerTileEntity(TileEntityBambooBridge.class, "bamboo_bridge");
        this.registerTileEntity(TileEntityUmberGolemStatue.class, "umber_golem_statue");
        this.registerTileEntity(TileEntityPetrifiedWoodChest.class, "petrified_wood_chest");
        this.registerTileEntity(TileEntityBones.class, "block_of_bones");
        this.registerTileEntity(TileEntityExtenderThingy.class, "extender_thingy");
        this.registerTileEntity(TileEntityFluidJar.class, "fluid_jar");
        this.registerTileEntity(TileEntityHoneyComb.class, "honey_comb");
        this.registerTileEntity(TileEntitySiloTank.class, "silo_tank");
        this.registerTileEntity(TileEntityComposter.class, "composter");
        this.registerTileEntity(TileEntityOfferingAltar.class, "offering_altar");
        this.registerTileEntity(TileEntitySmoothieMaker.class, "smoothie_maker");
        this.registerTileEntity(TileEntityTempleTeleporter.class, "temple_teleporter");
        this.registerTileEntity(TileEntityPreservedBlock.class, "preserved_block");
        this.registerTileEntity(TileEntityBambooPipe.class, "bamboo_pipe");
        this.registerTileEntity(TileEntityBambooPipeExtract.class, "bamboo_pipe_extract");
        this.registerTileEntity(TileEntityLiquifier.class, "liquifier");
    }

    private void registerTileEntity(Class<? extends TileEntity> cls, String baseName) {
        GameRegistry.registerTileEntity(cls, (String)("erebus." + baseName));
    }

    public void spawnCustomParticle(String particleName, World world, double x, double y, double z, double vecX, double vecY, double vecZ) {
    }

    public void registerEnitityRenderers() {
    }

    public Container getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        GuiID guiID = GuiID.values()[ID];
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tile = world.func_175625_s(pos);
        Entity entity = world.func_73045_a(x);
        switch (guiID) {
            case ANIMATED_BAMBOO_CRATE: {
                if (entity != null && entity instanceof EntityAnimatedBambooCrate) {
                    return new ContainerAnimatedBambooCrate(player.field_71071_by, (EntityAnimatedBambooCrate)entity);
                }
            }
            case ANT_INVENTORY: {
                if (entity != null && entity instanceof EntityBlackAnt) {
                    return new ContainerAntInventory(player.field_71071_by, (EntityBlackAnt)entity);
                }
            }
            case BAMBOO_CRATE: {
                return new ContainerBambooCrate(player.field_71071_by, (TileEntityBambooCrate)tile);
            }
            case COLOSSAL_CRATE: {
                ArrayList<TileEntityBambooCrate> list = new ArrayList<TileEntityBambooCrate>();
                for (int[] place : this.places) {
                    TileEntity te = world.func_175625_s(pos.func_177982_a(place[0], place[1], place[2]));
                    if (te == null || !(te instanceof TileEntityBambooCrate)) {
                        return null;
                    }
                    list.add((TileEntityBambooCrate)te);
                }
                return new ContainerColossalCrate(player.field_71071_by, list);
            }
            case COMPOSTER: {
                return new ContainerComposter(player.field_71071_by, (TileEntityComposter)tile);
            }
            case EXTENDER_THINGY: {
                return new ContainerExtenderThingy(player.field_71071_by, (TileEntityExtenderThingy)world.func_175625_s(pos));
            }
            case HONEY_COMB: {
                return new ContainerHoneyComb(player.field_71071_by, (TileEntityHoneyComb)tile);
            }
            case PETRIFIED_CHEST: {
                return new ContainerPetrifiedWoodChest((IInventory)player.field_71071_by, (IInventory)this.getContainer(world, pos, false), player);
            }
            case PETRIFIED_CRAFT: {
                return new ContainerPetrifiedCraftingTable(player.field_71071_by, world, pos);
            }
            case SILO_INVENTORY: {
                return new ContainerSilo(player.field_71071_by, (TileEntitySiloTank)tile);
            }
            case SMOOTHIE_MAKER: {
                return new ContainerSmoothieMaker(player.field_71071_by, (TileEntitySmoothieMaker)tile);
            }
            case UMBER_FURNACE: {
                return new ContainerUmberFurnace(player.field_71071_by, (TileEntityUmberFurnace)tile);
            }
            case LIQUIFIER: {
                return new ContainerLiquifier(player.field_71071_by, (TileEntityLiquifier)tile);
            }
        }
        return null;
    }

    @Nullable
    public ILockableContainer getContainer(World world, BlockPos pos, boolean allowBlocking) {
        TileEntity tileentity = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        Block blockIn = state.func_177230_c();
        if (!(tileentity instanceof TileEntityPetrifiedWoodChest)) {
            return null;
        }
        TileEntityPetrifiedWoodChest ilockablecontainer = (TileEntityPetrifiedWoodChest)tileentity;
        if (!allowBlocking && ((BlockPetrifiedChest)blockIn).isBlocked(world, pos)) {
            return null;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (!(block instanceof BlockPetrifiedChest)) continue;
            if (((BlockPetrifiedChest)block).isBlocked(world, blockpos)) {
                return null;
            }
            TileEntity tileentity1 = world.func_175625_s(blockpos);
            if (!(tileentity1 instanceof TileEntityPetrifiedWoodChest)) continue;
            if (enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH) {
                ilockablecontainer = new InventoryLargeChest("container.petrifiedChestDouble", (ILockableContainer)ilockablecontainer, (ILockableContainer)((TileEntityPetrifiedWoodChest)tileentity1));
                continue;
            }
            ilockablecontainer = new InventoryLargeChest("container.petrifiedChestDouble", (ILockableContainer)((TileEntityPetrifiedWoodChest)tileentity1), (ILockableContainer)ilockablecontainer);
        }
        return ilockablecontainer;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public static enum GuiID {
        BAMBOO_CRATE,
        COLOSSAL_CRATE,
        PETRIFIED_CRAFT,
        UMBER_FURNACE,
        PETRIFIED_CHEST,
        ANIMATED_BAMBOO_CRATE,
        EXTENDER_THINGY,
        HONEY_COMB,
        ANT_INVENTORY,
        SILO_INVENTORY,
        COMPOSTER,
        SMOOTHIE_MAKER,
        LIQUIFIER;

    }
}

