/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.core.helper.Spiral;
import erebus.core.helper.Utils;
import erebus.entity.EntityGrasshopper;
import java.awt.Point;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public abstract class EntityAIEatBlock
extends EntityAIBase {
    private static final int CHECKS_PER_TICK = 3;
    private final int EAT_SPEED;
    protected final EntityLiving entity;
    private final int maxGrowthMetadata;
    private final IBlockState blockState;
    private boolean hasTarget;
    public int cropX;
    public int cropY;
    public int cropZ;
    private int spiralIndex;
    public int eatTicks;
    private static final List<Point> spiral = new Spiral(16, 16).spiral();

    public EntityAIEatBlock(EntityLiving entity, IBlockState state, int maxGrowthMetadata, double moveSpeed, int eatSpeed) {
        this.func_75248_a(1);
        this.entity = entity;
        this.maxGrowthMetadata = maxGrowthMetadata;
        this.blockState = state;
        this.hasTarget = false;
        this.spiralIndex = 0;
        this.EAT_SPEED = eatSpeed * 20;
    }

    public boolean func_75250_a() {
        return this.entity.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
    }

    public boolean func_75253_b() {
        return !this.entity.func_70631_g_();
    }

    public void func_75246_d() {
        if (!this.func_75253_b()) {
            return;
        }
        int xCoord = (int)this.entity.field_70165_t;
        int yCoord = (int)this.entity.field_70163_u;
        int zCoord = (int)this.entity.field_70161_v;
        for (int i = 0; i < 3; ++i) {
            boolean flag;
            if (!this.hasTarget) {
                this.increment();
                Point p = this.getNextPoint();
                for (int y = -4; y < 4; ++y) {
                    if (!this.canEatBlock(this.entity.func_130014_f_().func_180495_p(new BlockPos(xCoord + p.x, yCoord + y, zCoord + p.y)))) continue;
                    this.cropX = xCoord + p.x;
                    this.cropY = yCoord + y;
                    this.cropZ = zCoord + p.y;
                    this.hasTarget = true;
                }
                continue;
            }
            if (!this.isEntityReady()) continue;
            this.moveToLocation();
            this.entity.func_70671_ap().func_75650_a((double)this.cropX + 0.5, (double)this.cropY + 0.5, (double)this.cropZ + 0.5, 30.0f, 8.0f);
            AxisAlignedBB blockbounds = this.getBlockAABB(this.cropX, this.cropY, this.cropZ);
            boolean bl = flag = this.entity.func_174813_aQ().field_72337_e >= blockbounds.field_72338_b && this.entity.func_174813_aQ().field_72338_b <= blockbounds.field_72337_e && this.entity.func_174813_aQ().field_72336_d >= blockbounds.field_72340_a && this.entity.func_174813_aQ().field_72340_a <= blockbounds.field_72336_d && this.entity.func_174813_aQ().field_72334_f >= blockbounds.field_72339_c && this.entity.func_174813_aQ().field_72339_c <= blockbounds.field_72334_f;
            if (flag && this.canEatBlock(this.getTargetBlock())) {
                this.prepareToEat();
                ++this.eatTicks;
                this.entity.func_130014_f_().func_175715_c(this.entity.func_145782_y(), new BlockPos(this.cropX, this.cropY, this.cropZ), this.getScaledEatTicks());
                if (!this.canEatBlock(this.getTargetBlock())) {
                    this.eatingInterupted();
                    this.hasTarget = false;
                    this.eatTicks = 0;
                    return;
                }
                if (this.EAT_SPEED <= this.eatTicks) {
                    this.entity.func_130014_f_().func_180498_a(null, 2001, new BlockPos(this.cropX, this.cropY, this.cropZ), Block.func_149682_b((Block)this.getTargetBlock().func_177230_c()) + (this.maxGrowthMetadata << 12));
                    if (!(this.entity instanceof EntityGrasshopper)) {
                        Utils.dropStack(this.entity.func_130014_f_(), new BlockPos(this.cropX, this.cropY, this.cropZ), new ItemStack(this.getTargetBlock().func_177230_c().func_180660_a(this.getTargetBlock(), this.entity.func_130014_f_().field_73012_v, 0), 1, this.getTargetBlock().func_177230_c().func_180651_a(this.getTargetBlock())));
                    }
                    this.hasTarget = false;
                    this.eatTicks = 0;
                    this.afterEaten();
                    return;
                }
            }
            if ((flag || this.eatTicks <= 0) && (this.eatTicks <= 0 || !this.entity.func_130014_f_().func_175623_d(new BlockPos(this.cropX, this.cropY, this.cropZ)))) continue;
            this.eatingInterupted();
            this.hasTarget = false;
            this.eatTicks = 0;
            return;
        }
    }

    protected int getScaledEatTicks() {
        return (int)((float)this.eatTicks / (float)this.EAT_SPEED * 10.0f);
    }

    private void increment() {
        ++this.spiralIndex;
        if (this.spiralIndex >= spiral.size()) {
            this.spiralIndex = 0;
        }
    }

    private Point getNextPoint() {
        return spiral.get(this.spiralIndex);
    }

    public IBlockState getTargetBlock() {
        IBlockState state = this.entity.func_130014_f_().func_180495_p(new BlockPos(this.cropX, this.cropY, this.cropZ));
        return state;
    }

    protected boolean canEatBlock(IBlockState state) {
        return state == this.blockState && state.func_177230_c() != Blocks.field_150350_a;
    }

    protected abstract boolean isEntityReady();

    protected abstract void moveToLocation();

    protected abstract void prepareToEat();

    protected abstract void eatingInterupted();

    protected abstract void afterEaten();

    protected AxisAlignedBB getBlockAABB(int x, int y, int z) {
        return new AxisAlignedBB((double)this.cropX - 0.3, (double)this.cropY - 0.3, (double)this.cropZ - 0.3, (double)this.cropX + 1.3, (double)this.cropY + 1.3, (double)this.cropZ + 1.3);
    }
}

