/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityAntlionBoss;
import erebus.entity.EntityThrownSand;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIAntlionBossAttack<T extends Entity>
extends EntityAIBase {
    World worldObj;
    EntityCreature attacker;
    int attackTick;
    double speedTowardsTarget;
    boolean longMemory;
    Path entityPathEntity;
    Class<T> classTarget;
    private int attackTimer;
    private int failedPathFindingPenalty;
    private int shouldDo;
    private boolean jumpAttack;

    public EntityAIAntlionBossAttack(EntityCreature entity, Class<T> entityClass, double moveSpeed, boolean memory) {
        this(entity, moveSpeed, memory);
        this.classTarget = entityClass;
    }

    public EntityAIAntlionBossAttack(EntityCreature entity, double moveSpeed, boolean memory) {
        this.attacker = entity;
        this.worldObj = entity.func_130014_f_();
        this.speedTowardsTarget = moveSpeed;
        this.longMemory = memory;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(entitylivingbase.getClass())) {
            return false;
        }
        if (--this.attackTimer <= 0) {
            this.entityPathEntity = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
            this.attackTimer = 4 + this.attacker.func_70681_au().nextInt(7);
            return this.entityPathEntity != null;
        }
        return true;
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : (!this.longMemory ? !this.attacker.func_70661_as().func_75500_f() : this.attacker.func_110173_bK()));
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.entityPathEntity, this.speedTowardsTarget);
        this.attackTimer = 0;
    }

    public void func_75251_c() {
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 20.0f, 20.0f);
        this.attacker.func_70625_a((Entity)entitylivingbase, 50.0f, 50.0f);
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && --this.attackTimer <= 0) {
            PathPoint finalPathPoint;
            this.attackTimer = this.failedPathFindingPenalty + 4 + this.attacker.func_70681_au().nextInt(7);
            this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.speedTowardsTarget);
            this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        double distance = this.attacker.field_70130_N * this.attacker.field_70130_N + entitylivingbase.field_70130_N;
        if (this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v) <= distance && this.attackTick <= 0) {
            this.attackTick = 20;
            this.worldObj.func_184133_a(null, this.attacker.func_180425_c(), ModSounds.ANTLION_GROWL, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.attacker.func_70652_k((Entity)entitylivingbase);
            entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.attacker), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 8.0 : 8.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            entitylivingbase.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.attacker.field_70177_z * 3.141593f / 180.0f)) * 0.3f), 0.1, (double)(MathHelper.func_76134_b((float)(this.attacker.field_70177_z * 3.141593f / 180.0f)) * 0.3f));
        }
        if (this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v) > distance + 9.0 && this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v) < distance + 256.0 && this.attackTick <= 0) {
            ++this.shouldDo;
            if (this.shouldDo <= 2) {
                this.attackTick = 5;
            } else {
                this.attackTick = 0;
                this.shouldDo = 0;
            }
            if (this.shouldDo == 1) {
                double direction = Math.toRadians(this.attacker.field_70761_aq);
                double targetX = entitylivingbase.field_70165_t - this.attacker.field_70165_t;
                double targetY = entitylivingbase.func_174813_aQ().field_72338_b + (double)entitylivingbase.field_70131_O - (this.attacker.field_70163_u + (double)this.attacker.field_70131_O);
                double targetZ = entitylivingbase.field_70161_v - this.attacker.field_70161_v;
                EntityThrownSand thrownsand = new EntityThrownSand(this.worldObj, (EntityLivingBase)this.attacker);
                thrownsand.func_70107_b(this.attacker.field_70165_t - Math.sin(direction) * 3.5, this.attacker.field_70163_u + (double)this.attacker.field_70131_O, this.attacker.field_70161_v + Math.cos(direction) * 3.5);
                thrownsand.func_70186_c(targetX, targetY, targetZ, 0.7f, 0.0f);
                this.worldObj.func_72838_d((Entity)thrownsand);
                this.attackTick = 30;
            }
        }
        if (this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v) > distance && this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v) <= distance + 256.0 && this.attackTick <= 0) {
            int x = this.worldObj.field_73012_v.nextInt(4);
            if (x == 0) {
                this.attackTick = 60;
                this.attacker.field_70181_x = 0.6199999868869781;
                this.jumpAttack = true;
            } else if (x == 1 && !this.jumpAttack && this.attacker.field_70122_E) {
                this.attackTick = 60;
                this.attacker.field_70181_x = 0.0;
                ((EntityAntlionBoss)this.attacker).setBlam(10, (byte)1);
            }
        }
        if (this.jumpAttack && this.attacker.field_70124_G && !(this.attacker.field_70181_x > 0.0)) {
            this.areaOfEffect();
            ((EntityAntlionBoss)this.attacker).spawnBlamParticles();
            this.jumpAttack = false;
        }
    }

    protected Entity areaOfEffect() {
        List list = this.worldObj.func_72872_a(EntityLivingBase.class, this.attacker.func_174813_aQ().func_72314_b(8.0, 1.0, 8.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityAntlionBoss) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.attacker), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 8.0 : 8.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.attacker.field_70177_z * 3.141593f / 180.0f))) * 1.0, 0.4, (double)MathHelper.func_76134_b((float)(this.attacker.field_70177_z * 3.141593f / 180.0f)) * 1.0);
            this.worldObj.func_184133_a(null, entity.func_180425_c(), ModSounds.ANTLION_SLAM, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.worldObj.func_184133_a(null, entity.func_180425_c(), ModSounds.ANTLION_EXPLODE, SoundCategory.HOSTILE, 1.0f, 1.0f);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 160, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160, 0));
        }
        return null;
    }
}

