/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.EntityBeetleLarva;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import erebus.tileentity.TileEntityTitanChest;
import erebus.tileentity.TileEntityTitanEnderChest;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTitanBeetle
extends EntityTameable {
    private static final DataParameter<Byte> BEETLE_TYPE = EntityDataManager.func_187226_a(EntityTitanBeetle.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> OPENTICKS = EntityDataManager.func_187226_a(EntityTitanBeetle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PREV_OPENTICKS = EntityDataManager.func_187226_a(EntityTitanBeetle.class, (DataSerializer)DataSerializers.field_187193_c);
    private EntityAINearestAttackableTarget aiNearestAttackableTarget;
    boolean isOpen;
    int shagCount;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);

    public EntityTitanBeetle(World world) {
        super(world);
        this.field_70138_W = 2.0f;
        this.func_70105_a(2.5f, 1.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OPENTICKS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PREV_OPENTICKS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BEETLE_TYPE, (Object)new Byte(0));
    }

    protected void func_184651_r() {
        this.aiNearestAttackableTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.5, ModItems.TURNIP, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiNearestAttackableTarget);
    }

    public EntityTitanBeetle setContents(IInventory chest) {
        if (chest == null) {
            return this;
        }
        this.inventory = NonNullList.func_191197_a((int)chest.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i).func_190926_b()) continue;
            this.inventory.set(i, (Object)chest.func_70301_a(i).func_77946_l());
            chest.func_70299_a(i, ItemStack.field_190927_a);
        }
        return this;
    }

    public void setOpen(boolean open) {
        if (!this.func_130014_f_().field_72995_K) {
            if (open) {
                if (this.getTameState() == 3) {
                    this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, 0.9f);
                } else {
                    this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187520_aJ, SoundCategory.BLOCKS, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            } else if (this.getTameState() == 3) {
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, 0.9f);
            } else {
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187519_aI, SoundCategory.BLOCKS, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
        this.isOpen = open;
    }

    public boolean getOpen() {
        return this.isOpen;
    }

    public void setOpenTicks(float ticks) {
        this.field_70180_af.func_187227_b(OPENTICKS, (Object)Float.valueOf(ticks));
    }

    public float getOpenTicks() {
        return ((Float)this.field_70180_af.func_187225_a(OPENTICKS)).floatValue();
    }

    public void setPrevOpenTicks(float ticks) {
        this.field_70180_af.func_187227_b(PREV_OPENTICKS, (Object)Float.valueOf(ticks));
    }

    public float getPrevOpenTicks() {
        return ((Float)this.field_70180_af.func_187225_a(PREV_OPENTICKS)).floatValue();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.field_70128_L) {
            for (ItemStack is : this.inventory) {
                if (is.func_190926_b()) continue;
                Utils.dropStack(this.func_130014_f_(), this.func_180425_c(), is);
            }
        }
        if (this.func_130014_f_().field_72995_K && this.getTameState() == 4) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 1.2;
            double offSetZ = Math.cos(a) * 1.2;
            this.enderChestParticles(this.func_130014_f_(), this.field_70165_t - offSetX, this.field_70163_u + 1.2, this.field_70161_v - offSetZ, this.field_70146_Z);
        }
        if (this.shagCount > 0) {
            --this.shagCount;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            this.setPrevOpenTicks(this.getOpenTicks());
            if (this.isOpen && this.getOpenTicks() < 1.0f) {
                this.setOpenTicks(this.getOpenTicks() + 0.1f);
            }
            if (!this.isOpen && this.getOpenTicks() > 0.0f) {
                this.setOpenTicks(this.getOpenTicks() - 0.1f);
            }
            if (this.getOpenTicks() > 1.0f) {
                this.setOpenTicks(1.0f);
            }
            if (this.getOpenTicks() < 0.0f) {
                this.setOpenTicks(0.0f);
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 60.0 : 60.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.BOMBARDIER_BEETLE_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.BOMBARDIER_BEETLE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL;
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    protected boolean func_70692_ba() {
        return this.getTameState() == 0;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_70692_ba() && super.func_184652_a(player);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.getTameState() >= 2) {
            this.func_70099_a(ItemMaterials.EnumErebusMaterialsType.BEETLE_RIDING_KIT.createStack(), 0.0f);
        }
        int var3 = 1 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + looting);
        for (int a = 0; a < var3; ++a) {
            this.func_70099_a(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO.createStack(), 0.0f);
        }
        this.func_70099_a(new ItemStack(ModItems.EREBUS_FOOD, 1 + this.field_70146_Z.nextInt(1), this.func_70027_ad() ? ItemErebusFood.EnumFoodType.TITAN_CHOP_COOKED.ordinal() : ItemErebusFood.EnumFoodType.TITAN_CHOP_RAW.ordinal()), 0.0f);
        this.dropChests();
    }

    public void dropChests() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getTameState() == 3) {
                this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150486_ae), 1);
            }
            if (this.getTameState() == 4) {
                this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150477_bB), 1);
            }
        }
    }

    public void openGUI(EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K && !this.func_184207_aI() && this.getTameState() != 0) {
            if (this.getTameState() == 3) {
                player.func_71007_a((IInventory)new TileEntityTitanChest(this));
            }
            if (this.getTameState() == 4) {
                this.setOpen(true);
                InventoryEnderChest inventoryenderchest = player.func_71005_bN();
                inventoryenderchest.func_146031_a((TileEntityEnderChest)new TileEntityTitanEnderChest(this));
                player.func_71007_a((IInventory)inventoryenderchest);
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack is = player.field_71071_by.func_70448_g();
        float healingBuff = 0.0f;
        if (this.getTameState() == 3 && player.func_70093_af()) {
            this.openGUI(player);
            return true;
        }
        if (this.getTameState() == 4 && player.func_70093_af()) {
            this.openGUI(player);
            return true;
        }
        if (!is.func_190926_b() && is.func_77973_b() == ModItems.MATERIALS && is.func_77952_i() == ItemMaterials.EnumErebusMaterialsType.BEETLE_TAMING_AMULET.ordinal() && this.getTameState() == 0) {
            healingBuff = (float)(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 20.0 : 20.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            is.func_190918_g(1);
            this.setTameState((byte)1);
            this.func_70908_e(true);
            player.func_184609_a(hand);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiNearestAttackableTarget);
            this.func_70624_b(null);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
            this.func_70691_i(healingBuff);
            return true;
        }
        if (!is.func_190926_b() && is.func_77973_b() == ModItems.MATERIALS && is.func_77952_i() == ItemMaterials.EnumErebusMaterialsType.BEETLE_RIDING_KIT.ordinal() && this.getTameState() == 1) {
            is.func_190918_g(1);
            player.func_184609_a(hand);
            this.setTameState((byte)2);
            return true;
        }
        if (!is.func_190926_b() && is.func_77973_b() == ModItems.TURNIP && !this.shagging() && this.getTameState() != 0) {
            is.func_190918_g(1);
            this.shagCount = 600;
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), ModSounds.BEETLE_LARVA_MUNCH, SoundCategory.NEUTRAL, 1.0f, 0.75f);
            return true;
        }
        if (is.func_190926_b() && this.getTameState() >= 2) {
            if (!this.func_130014_f_().field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        if (!is.func_190926_b() && is.func_77973_b() == ModItems.MATERIALS && is.func_77952_i() == ItemMaterials.EnumErebusMaterialsType.BAMBOO.ordinal() && this.getTameState() != 0) {
            healingBuff = (float)(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 5.0 : 5.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(healingBuff);
                this.func_70908_e(true);
                player.func_184609_a(hand);
                is.func_190918_g(1);
                if (this.func_110143_aJ() == this.func_110138_aP()) {
                    this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), ModSounds.BEETLE_LARVA_MUNCH, SoundCategory.NEUTRAL, 1.0f, 0.75f);
                }
            }
            return true;
        }
        if (!is.func_190926_b()) {
            boolean flag = false;
            if (!flag && this.getTameState() == 2 && is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                this.setTameState((byte)3);
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187665_Y, SoundCategory.NEUTRAL, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                flag = true;
            }
            if (flag && this.getTameState() == 3) {
                if (!player.field_71075_bZ.field_75098_d) {
                    is.func_190918_g(1);
                }
                return true;
            }
            if (!flag && this.getTameState() == 2 && is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150477_bB)) {
                this.setTameState((byte)4);
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187665_Y, SoundCategory.NEUTRAL, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                flag = true;
            }
            if (flag && this.getTameState() == 4) {
                if (!player.field_71075_bZ.field_75098_d) {
                    is.func_190918_g(1);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean shagging() {
        return this.shagCount > 0;
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.4f;
            forward = entitylivingbase.field_191988_bg * 0.4f;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, up, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(strafe, up, forward);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, up, forward);
        }
    }

    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.1;
            double offSetZ = Math.cos(a) * 0.1;
            entity.func_70107_b(this.field_70165_t - offSetX, this.field_70163_u + 1.1 + entity.func_70033_W(), this.field_70161_v - offSetZ);
        }
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_175144_cb() : !this.field_70170_p.field_72995_K;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void enderChestParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 3; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextInt(2) * 2 - 1;
            int motionZ = rand.nextInt(2) * 2 - 1;
            velY = ((double)rand.nextFloat() - 0.5) * 0.125;
            velZ = rand.nextFloat() * 1.0f * (float)motionZ;
            velX = rand.nextFloat() * 1.0f * (float)motionX;
            Erebus.PROXY.spawnCustomParticle("portal", this.func_130014_f_(), x, y, z, velX, velY, velZ);
        }
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return this.spawnBabyAnimal(entityageable);
    }

    public boolean func_70877_b(ItemStack is) {
        if (this.getTameState() != 0) {
            return !is.func_190926_b() && is.func_77973_b() == ModItems.TURNIP;
        }
        return false;
    }

    public EntityBeetleLarva spawnBabyAnimal(EntityAgeable entityageable) {
        EntityBeetleLarva entityBeetleLarva = new EntityBeetleLarva(this.func_130014_f_());
        entityBeetleLarva.setLarvaType((byte)3);
        return entityBeetleLarva;
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (this.getTameState() != 0) {
            if (entity instanceof EntityPlayer) {
                super.func_70624_b((EntityLivingBase)null);
            }
        } else {
            super.func_70624_b(entity);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getTameState() != 0 && entity instanceof EntityPlayer) {
            this.func_70624_b(null);
            return false;
        }
        if (entity != null && this.func_70068_e(entity) <= 2.5 && entity.func_174813_aQ().field_72337_e > this.func_174813_aQ().field_72338_b && entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 4.0 : 4.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
        }
        return super.func_70652_k(entity);
    }

    public void setTameState(byte tameState) {
        this.field_70180_af.func_187227_b(BEETLE_TYPE, (Object)tameState);
    }

    public byte getTameState() {
        return (Byte)this.field_70180_af.func_187225_a(BEETLE_TYPE);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.loadFromNbt(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        super.func_189511_e(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(NBTTagCompound compound) {
        this.setTameState(compound.func_74771_c("tameState"));
        if (this.getTameState() == 3) {
            this.inventory = NonNullList.func_191197_a((int)this.getSizeInventory(), (Object)ItemStack.field_190927_a);
            if (compound.func_150297_b("Items", 9)) {
                ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
            }
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound compound) {
        compound.func_74774_a("tameState", this.getTameState());
        if (this.getTameState() == 3) {
            ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.inventory, (boolean)false);
        }
        return compound;
    }

    public int getSizeInventory() {
        return this.inventory.size();
    }
}

