/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import erebus.entity.ai.PathNavigateAboveWater;
import erebus.items.ItemMaterials;
import erebus.world.ChunkProviderErebus;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityPondSkater
extends EntityMob {
    public EntityPondSkater(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.8f);
        this.field_70138_W = 0.0f;
        this.func_184644_a(PathNodeType.WALKABLE, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.LAVA, -8.0f);
        this.func_184644_a(PathNodeType.WATER, 16.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIWaterWander(this, 0.5, 10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateAboveWater((EntityLiving)this, world);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70601_bi() {
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        if (y <= ChunkProviderErebus.swampWaterHeight) {
            return this.func_130014_f_().func_72855_b(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72875_a(this.func_174813_aQ(), Material.field_151586_h);
        }
        return false;
    }

    public int func_70641_bl() {
        return 6;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187549_bG, 0.125f, 0.125f);
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.HYDROFUGE.ordinal()), 0.0f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.func_130014_f_().func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151586_h) {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x = 0.0;
            }
            this.field_70143_R = 0.0f;
        }
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && !this.func_70638_az().func_70090_H()) {
            this.func_70624_b(null);
        }
        if (this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
        }
    }

    public boolean isEntityInWater(EntityLivingBase entity) {
        return entity.func_70090_H();
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity) && entity.func_70090_H()) {
            if (super.func_70652_k(entity) && entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public class AIWaterWander
    extends EntityAIWander {
        private final EntityPondSkater skater;

        public AIWaterWander(EntityPondSkater skaterIn, double speedIn, int chance) {
            super((EntityCreature)skaterIn, speedIn, chance);
            this.func_75248_a(1);
            this.skater = skaterIn;
        }

        @Nullable
        protected Vec3d func_190864_f() {
            return RandomPositionGenerator.func_75463_a((EntityCreature)this.skater, (int)16, (int)0);
        }
    }
}

