/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBeetle;
import erebus.entity.EntityBombardierBeetle;
import erebus.entity.EntityRhinoBeetle;
import erebus.entity.EntityStagBeetle;
import erebus.entity.EntityTitanBeetle;
import erebus.entity.ai.EntityAIEatWoodenItem;
import erebus.network.client.PacketParticle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class EntityBeetleLarva
extends EntityAnimal {
    private static final DataParameter<Byte> LARVA_TYPE = EntityDataManager.func_187226_a(EntityBeetleLarva.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> LARVA_SIZE = EntityDataManager.func_187226_a(EntityBeetleLarva.class, (DataSerializer)DataSerializers.field_187193_c);
    public boolean isEating;
    public boolean isSquashed;

    public EntityBeetleLarva(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.5f);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.field_70138_W = 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LARVA_SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(LARVA_TYPE, (Object)new Byte(0));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.48));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEatWoodenItem(this, 0.48, 10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.48, Items.field_151055_y, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.48));
    }

    public boolean func_70631_g_() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getLarvaType() == 0 || this.getLarvaType() == 4;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 8.0 : 8.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        int duration = 0;
        if (!this.func_130014_f_().field_72995_K && player.func_174813_aQ().field_72337_e >= this.func_174813_aQ().field_72338_b && player.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72337_e && player.func_174813_aQ().field_72336_d >= this.func_174813_aQ().field_72340_a && player.func_174813_aQ().field_72340_a <= this.func_174813_aQ().field_72336_d && player.func_174813_aQ().field_72334_f >= this.func_174813_aQ().field_72339_c && player.func_174813_aQ().field_72339_c <= this.func_174813_aQ().field_72334_f && player.field_70137_T > player.field_70163_u) {
            if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.NORMAL) {
                duration = 7;
            } else if (this.func_130014_f_().func_175659_aa() == EnumDifficulty.HARD) {
                duration = 15;
            }
            if (duration > 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, duration * 20, 0));
            }
            this.setisSquashed(true);
            this.func_70106_y();
            this.func_70609_aI();
        }
    }

    protected SoundEvent func_184639_G() {
        SoundEvent actionSound = ModSounds.BEETLE_LARVA_SOUND;
        return actionSound;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.BEETLE_LARVA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected SoundEvent getJumpedOnSound() {
        return ModSounds.BEETLE_LARVA_SPLAT;
    }

    protected SoundEvent getHasMunched() {
        return ModSounds.BEETLE_LARVA_MUNCH;
    }

    public void func_70619_bc() {
        super.func_70619_bc();
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_130014_f_().field_72995_K) {
            float size = this.getLarvaSize();
            this.func_70105_a(0.9f * size, 0.5f * size);
        }
        if (!this.func_130014_f_().field_72995_K && this.getLarvaSize() > 1.8f) {
            this.func_70106_y();
            this.spawnBeetle();
        }
    }

    private void spawnBeetle() {
        EntityBeetle entityBeetle;
        if (this.getLarvaType() == 0) {
            entityBeetle = new EntityBeetle(this.func_130014_f_());
            entityBeetle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_130014_f_().func_72838_d((Entity)entityBeetle);
        }
        if (this.getLarvaType() == 1) {
            entityBeetle = new EntityBeetle(this.func_130014_f_());
            entityBeetle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityBeetle.setTame(true);
            this.func_130014_f_().func_72838_d((Entity)entityBeetle);
        } else if (this.getLarvaType() == 2) {
            EntityRhinoBeetle entityRhinoBeetle = new EntityRhinoBeetle(this.func_130014_f_());
            entityRhinoBeetle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityRhinoBeetle.setTameState((byte)1);
            this.func_130014_f_().func_72838_d((Entity)entityRhinoBeetle);
        } else if (this.getLarvaType() == 3) {
            EntityTitanBeetle entityTitanBeetle = new EntityTitanBeetle(this.func_130014_f_());
            entityTitanBeetle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityTitanBeetle.setTameState((byte)1);
            this.func_130014_f_().func_72838_d((Entity)entityTitanBeetle);
        } else if (this.getLarvaType() == 4) {
            EntityBombardierBeetle entityBombardierBeetle = new EntityBombardierBeetle(this.func_130014_f_());
            entityBombardierBeetle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_130014_f_().func_72838_d((Entity)entityBombardierBeetle);
        } else if (this.getLarvaType() == 5) {
            EntityStagBeetle entityStagBeetle = new EntityStagBeetle(this.func_130014_f_());
            entityStagBeetle.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityStagBeetle.setTameState((byte)1);
            this.func_130014_f_().func_72838_d((Entity)entityStagBeetle);
        }
    }

    public void func_70609_aI() {
        super.func_70609_aI();
        if (this.isSquashed) {
            if (!this.func_130014_f_().field_72995_K) {
                Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.BEETLE_LARVA_SQUISH, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
            }
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), this.getJumpedOnSound(), SoundCategory.NEUTRAL, 1.0f, 0.5f);
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), this.func_184615_bR(), SoundCategory.NEUTRAL, 1.0f, 0.7f);
            if (!this.func_130014_f_().field_72995_K) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.func_70099_a(new ItemStack(Items.field_151045_i), 0.0f);
                }
                this.func_70099_a(new ItemStack(Items.field_151123_aH), 0.0f);
            }
        }
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (recentlyHit) {
            if (this.func_70027_ad()) {
                this.func_70099_a(new ItemStack(ModItems.EREBUS_FOOD, 1, 1), 0.0f);
            } else {
                this.func_70099_a(new ItemStack(ModItems.EREBUS_FOOD, 1, 0), 0.0f);
            }
        }
    }

    private boolean isStick(ItemStack stack) {
        int stick = OreDictionary.getOreID((String)"stickWood");
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (id != stick) continue;
            return true;
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (!this.func_130014_f_().field_72995_K && this.isStick(stack) && this.getLarvaType() != 4) {
            this.setLarvaSize(this.getLarvaSize() + 0.1f);
            stack.func_190918_g(1);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void setIsEating(boolean eating) {
        this.isEating = eating;
    }

    public void setisSquashed(boolean squashed) {
        this.isSquashed = squashed;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("larvaSize", this.getLarvaSize());
        nbt.func_74774_a("larvaType", this.getLarvaType());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setLarvaSize(nbt.func_74760_g("larvaSize"));
        this.setLarvaType(nbt.func_74771_c("larvaType"));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (LARVA_SIZE.equals(key)) {
            float size = this.getLarvaSize();
            this.setNewSize(0.9f * size, 0.5f * size);
        }
        super.func_184206_a(key);
    }

    protected void setNewSize(float width, float height) {
        if (this.field_70130_N != width || this.field_70131_O != height) {
            float f = this.field_70130_N;
            this.field_70130_N = width;
            this.field_70131_O = height;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)width, axisalignedbb.field_72338_b + (double)height, axisalignedbb.field_72339_c + (double)width));
            if (width > f && !this.field_70148_d && !this.func_130014_f_().field_72995_K) {
                this.func_70091_d(MoverType.SELF, f - width, 0.0, f - width);
            }
        }
    }

    public void setLarvaSize(float size) {
        this.field_70180_af.func_187227_b(LARVA_SIZE, (Object)Float.valueOf(size));
    }

    public void setLarvaType(byte isTamed) {
        this.field_70180_af.func_187227_b(LARVA_TYPE, (Object)isTamed);
    }

    public float getLarvaSize() {
        return ((Float)this.field_70180_af.func_187225_a(LARVA_SIZE)).floatValue();
    }

    public byte getLarvaType() {
        return (Byte)this.field_70180_af.func_187225_a(LARVA_TYPE);
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }
}

