/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityBeetleLarva;
import erebus.items.ItemMaterials;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class EntityBeetle
extends EntityAnimal {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityBeetle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityBeetle.class, (DataSerializer)DataSerializers.field_187198_h);
    int shagCount;

    public EntityBeetle(World world) {
        super(world);
        this.func_70105_a(1.6f, 0.9f);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN_TYPE, (Object)this.field_70146_Z.nextInt(51));
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.5, ModItems.TURNIP, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public int func_70658_aO() {
        return 4;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.BEETLE_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.BEETLE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.shagCount > 0) {
            --this.shagCount;
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (FluidUtil.getFluidHandler((ItemStack)stack) != null) {
            FluidStack fluidStack = this.getFluid(stack);
            if (fluidStack != null) {
                return false;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151133_ar && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                ItemStack newStack = FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"beetle_juice"), 1000));
                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                if (!player.field_71071_by.func_70441_a(newStack)) {
                    player.func_71019_a(newStack, false);
                }
                return true;
            }
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.TURNIP && !this.shagging()) {
            stack.func_190918_g(1);
            this.setTame(true);
            this.shagCount = 600;
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), ModSounds.BEETLE_LARVA_MUNCH, SoundCategory.NEUTRAL, 1.0f, 0.75f);
            return true;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.MATERIALS && stack.func_77952_i() == ItemMaterials.EnumErebusMaterialsType.BEETLE_TAMING_AMULET.ordinal()) {
            stack.func_190918_g(1);
            this.setTame(true);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    public FluidStack getFluid(ItemStack container) {
        return FluidUtil.getFluidContained((ItemStack)container);
    }

    public boolean shagging() {
        return this.shagCount > 0;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (recentlyHit) {
            int chance = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + looting);
            for (int amount = 0; amount < chance; ++amount) {
                this.func_70099_a(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.PLATE_EXO.ordinal()), 0.0f);
            }
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == ModItems.TURNIP;
    }

    public EntityBeetleLarva spawnBabyAnimal(EntityAgeable entityageable) {
        EntityBeetleLarva entityBeetleLarva = new EntityBeetleLarva(this.func_130014_f_());
        entityBeetleLarva.setLarvaType((byte)1);
        return entityBeetleLarva;
    }

    protected boolean func_70692_ba() {
        return !this.getIsTame();
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return this.spawnBabyAnimal(entityageable);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setTame(boolean hasMated) {
        this.field_70180_af.func_187227_b(TAMED, (Object)hasMated);
    }

    public boolean getIsTame() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("beetleSkin", this.getSkin());
        nbt.func_74757_a("isTamed", this.getIsTame());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSkin(nbt.func_74762_e("beetleSkin"));
        this.setTame(nbt.func_74767_n("isTamed"));
    }
}

