/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.ai.EntityAIAntlionBossAttack;
import erebus.items.ItemMaterials;
import erebus.network.client.PacketParticle;
import erebus.world.feature.structure.WorldGenAntlionDungeon;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAntlionBoss
extends EntityMob {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    private static final DataParameter<BlockPos> SPAWN_ORIGIN = EntityDataManager.func_187226_a(EntityAntlionBoss.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Byte> IN_PYRAMID = EntityDataManager.func_187226_a(EntityAntlionBoss.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> BLAM = EntityDataManager.func_187226_a(EntityAntlionBoss.class, (DataSerializer)DataSerializers.field_187191_a);
    private int blamCount;
    public int deathTicks;

    public EntityAntlionBoss(World world) {
        super(world);
        this.func_70105_a(6.0f, 2.0f);
        this.field_70178_ae = true;
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 100;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new EntityAIAntlionBossAttack<EntityPlayer>((EntityCreature)this, EntityPlayer.class, 0.6, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWN_ORIGIN, (Object)new BlockPos(0, 0, 0));
        this.field_70180_af.func_187214_a(IN_PYRAMID, (Object)0);
        this.field_70180_af.func_187214_a(BLAM, (Object)3);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 400.0 : 400.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 6.0 : 6.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.ANTLION_GROWL;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.ANTLION_GROWL;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.blamCount <= 75) {
            ++this.blamCount;
        }
        if (this.blamCount == 5) {
            this.setBlam(5, (byte)3);
        }
        if (this.blamCount < 75 && this.blamCount > 10 && this.getBlam() >= 1 && this.getBlam() <= 2) {
            if (this.blamCount % 5 == 0 && this.blamCount % 10 != 0) {
                this.setBlam(this.blamCount, (byte)2);
            } else if (this.blamCount % 10 == 0) {
                this.setBlam(this.blamCount, (byte)1);
                this.areaOfEffect2();
            }
        }
        if (this.blamCount == 75) {
            this.setBlam(75, (byte)3);
        }
        if (this.getBlam() == 1) {
            this.spawnRumbleParticles();
        }
        this.destroyBlocksInAABB(this.func_174813_aQ());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e) || source instanceof EntityDamageSourceIndirect) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void spawnBlamParticles() {
        if (!this.func_130014_f_().field_72995_K && this.field_70122_E) {
            Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.ANTLION_BLAM, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
    }

    public void spawnRumbleParticles() {
        if (!this.func_130014_f_().field_72995_K) {
            Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.ANTLION_RUMBLE, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
    }

    public void setBlam(int count, byte action) {
        this.blamCount = count;
        this.field_70180_af.func_187227_b(BLAM, (Object)action);
    }

    public byte getBlam() {
        return (Byte)this.field_70180_af.func_187225_a(BLAM);
    }

    public void setInPyramid(byte state) {
        this.field_70180_af.func_187227_b(IN_PYRAMID, (Object)state);
    }

    public byte getInPyramid() {
        return (Byte)this.field_70180_af.func_187225_a(IN_PYRAMID);
    }

    public int getSpawnPointX() {
        return ((BlockPos)this.field_70180_af.func_187225_a(SPAWN_ORIGIN)).func_177958_n();
    }

    public int getSpawnPointY() {
        return ((BlockPos)this.field_70180_af.func_187225_a(SPAWN_ORIGIN)).func_177956_o();
    }

    public int getSpawnPointZ() {
        return ((BlockPos)this.field_70180_af.func_187225_a(SPAWN_ORIGIN)).func_177952_p();
    }

    public void setSpawnPoint(int x, int y, int z) {
        this.field_70180_af.func_187227_b(SPAWN_ORIGIN, (Object)new BlockPos(x, y, z));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("inPyramid", this.getInPyramid());
        nbt.func_74768_a("spawnPointX", this.getSpawnPointX());
        nbt.func_74768_a("spawnPointY", this.getSpawnPointY());
        nbt.func_74768_a("spawnPointZ", this.getSpawnPointZ());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setInPyramid(nbt.func_74771_c("inPyramid"));
        this.setSpawnPoint(nbt.func_74762_e("spawnPointX"), nbt.func_74762_e("spawnPointY"), nbt.func_74762_e("spawnPointZ"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected Entity areaOfEffect2() {
        List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(16.0, 1.0, 16.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityAntlionBoss) continue;
            float Knockback = (-3.0f + (float)this.func_130014_f_().field_73012_v.nextInt(4)) * 0.1f;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * -3.141593f + (float)this.func_130014_f_().field_73012_v.nextInt(3) + 7.8662776E-4f)) * Knockback), 0.01, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * -3.141593f + (float)this.func_130014_f_().field_73012_v.nextInt(3) + 7.8662776E-4f)) * Knockback));
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), ModSounds.ANTLION_SLAM, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        return null;
    }

    protected void func_70609_aI() {
        int i;
        int j;
        ++this.deathTicks;
        if (this.deathTicks % 25 == 1) {
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), ModSounds.ANTLION_GROWL, SoundCategory.HOSTILE, 1.0f, this.func_130014_f_().field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), ModSounds.ANTLION_GROWL, SoundCategory.HOSTILE, 1.0f, this.func_130014_f_().field_73012_v.nextFloat() * 0.1f + 0.3f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), ModSounds.ANTLION_GROWL, SoundCategory.HOSTILE, 1.0f, this.func_130014_f_().field_73012_v.nextFloat() * 0.1f + 0.1f);
        }
        if (this.deathTicks >= 180 && this.deathTicks <= 200 && !this.func_130014_f_().field_72995_K) {
            Erebus.NETWORK_WRAPPER.sendToAll((IMessage)new PacketParticle(PacketParticle.ParticleType.BOSS_DEATH, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
        if (!this.func_130014_f_().field_72995_K && this.deathTicks > 150 && this.deathTicks % 5 == 0) {
            for (i = 1000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
        this.func_70091_d(MoverType.SELF, 0.0, 0.31000000014901163, 0.0);
        this.spawnRumbleParticles();
        this.field_70761_aq = this.field_70760_ar += 0.03f;
        this.field_70721_aZ = 0.5f;
        if (this.deathTicks == 200 && !this.func_130014_f_().field_72995_K) {
            for (i = 2000; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            if (this.getInPyramid() == 1) {
                WorldGenAntlionDungeon.setTeleporter(this.func_130014_f_(), new BlockPos(this.getSpawnPointX(), this.getSpawnPointY(), this.getSpawnPointZ()), 7, new BlockPos(this.getSpawnPointX(), this.getSpawnPointY() + 12, this.getSpawnPointZ()));
                WorldGenAntlionDungeon.setTeleporter(this.func_130014_f_(), new BlockPos(this.getSpawnPointX() + 1, this.getSpawnPointY(), this.getSpawnPointZ()), 6, new BlockPos(this.getSpawnPointX() + 1, this.getSpawnPointY() + 12, this.getSpawnPointZ()));
                WorldGenAntlionDungeon.setTeleporter(this.func_130014_f_(), new BlockPos(this.getSpawnPointX(), this.getSpawnPointY(), this.getSpawnPointZ() + 1), 9, new BlockPos(this.getSpawnPointX(), this.getSpawnPointY() + 12, this.getSpawnPointZ() + 1));
                WorldGenAntlionDungeon.setTeleporter(this.func_130014_f_(), new BlockPos(this.getSpawnPointX() + 1, this.getSpawnPointY(), this.getSpawnPointZ() + 1), 8, new BlockPos(this.getSpawnPointX() + 1, this.getSpawnPointY() + 12, this.getSpawnPointZ() + 1));
            }
            this.func_130014_f_().func_175656_a(this.func_180425_c(), ModBlocks.ANTLION_EGG.func_176223_P());
            Utils.dropStackNoRandom(this.func_130014_f_(), this.func_180425_c().func_177984_a(), ItemMaterials.EnumErebusMaterialsType.SOUL_CRYSTAL.createStack());
            Utils.dropStackNoRandom(this.func_130014_f_(), this.func_180425_c().func_177984_a(), new ItemStack((Item)ModItems.WAR_HAMMER));
            this.func_70106_y();
        }
    }

    public void destroyBlocksInAABB(AxisAlignedBB AABB) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        int i = MathHelper.func_76128_c((double)(AABB.field_72340_a - 1.0));
        int j = MathHelper.func_76128_c((double)(AABB.field_72338_b - 0.2));
        int k = MathHelper.func_76128_c((double)(AABB.field_72339_c - 1.0));
        int l = MathHelper.func_76128_c((double)(AABB.field_72336_d + 1.0));
        int i1 = MathHelper.func_76128_c((double)AABB.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)(AABB.field_72334_f + 1.0));
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    Block block = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                    Block blockBelow = this.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c();
                    if (block != Blocks.field_150354_m || blockBelow == ModBlocks.TEMPLE_BRICK_UNBREAKING) continue;
                    this.func_130014_f_().func_175698_g(pos);
                    this.func_130014_f_().func_180498_a(null, 2001, pos, Block.func_149682_b((Block)block));
                }
            }
        }
    }
}

