/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.sound;

import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ErebusMusicHandler {
    private MusicTicker prevMusicTicker;
    private Field mcMusicTickerField;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mcMusicTickerField == null) {
            this.mcMusicTickerField = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"mcMusicTicker", "field_147126_aw"});
        }
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                if (mc.field_71441_e.field_73011_w.getDimension() == ConfigHandler.INSTANCE.erebusDimensionID && this.prevMusicTicker == null) {
                    this.prevMusicTicker = this.getMcMusicTicker();
                    this.setMcMusicTicker(new ErebusMusicTicker(mc));
                } else if (mc.field_71441_e.field_73011_w.getDimension() != ConfigHandler.INSTANCE.erebusDimensionID && this.prevMusicTicker != null) {
                    this.setMcMusicTicker(this.prevMusicTicker);
                    this.prevMusicTicker = null;
                }
            } else if (this.prevMusicTicker != null) {
                this.setMcMusicTicker(this.prevMusicTicker);
                this.prevMusicTicker = null;
            }
        }
    }

    private void setMcMusicTicker(MusicTicker musicTicker) {
        try {
            this.mcMusicTickerField.set(Minecraft.func_71410_x(), musicTicker);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private MusicTicker getMcMusicTicker() {
        try {
            return (MusicTicker)this.mcMusicTickerField.get(Minecraft.func_71410_x());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ErebusMusicTicker
    extends MusicTicker {
        private final Random RNG = new Random();
        private final Minecraft mc;
        private ISound currentSound;
        private int timeUntilMusic = 100;
        private static final int MIN_WAIT = 6000;
        private static final int MAX_WAIT = 12000;

        public ErebusMusicTicker(Minecraft minecraft) {
            super(minecraft);
            this.mc = minecraft;
        }

        public void func_73660_a() {
            if (this.currentSound != null) {
                if (!ModSounds.MUSIC_EREBUS_DIMENSION.func_187503_a().equals((Object)this.currentSound.func_147650_b())) {
                    this.mc.func_147118_V().func_147683_b(this.currentSound);
                    this.timeUntilMusic = MathHelper.func_76136_a((Random)this.RNG, (int)0, (int)3000);
                }
                if (!this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                    this.currentSound = null;
                    this.timeUntilMusic = Math.min(MathHelper.func_76136_a((Random)this.RNG, (int)6000, (int)12000), this.timeUntilMusic);
                }
            }
            if (this.currentSound == null && this.timeUntilMusic-- <= 0) {
                this.currentSound = PositionedSoundRecord.func_184370_a((SoundEvent)ModSounds.MUSIC_EREBUS_DIMENSION);
                this.mc.func_147118_V().func_147682_a(this.currentSound);
                this.timeUntilMusic = Integer.MAX_VALUE;
            }
        }
    }
}

