/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.tile;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.client.model.block.ModelOfferingAltar;
import erebus.tileentity.TileEntityOfferingAltar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityOfferingAltarRenderer
extends TileEntitySpecialRenderer<TileEntityOfferingAltar> {
    private final ResourceLocation TEXTURE = new ResourceLocation("erebus:textures/special/tiles/offering_altar.png");
    private final ModelOfferingAltar MODEL = new ModelOfferingAltar();

    public void renderTile(TileEntityOfferingAltar tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || state.func_177230_c() != ModBlocks.ALTAR_OFFERING) {
            return;
        }
        this.func_147499_a(this.TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.MODEL.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        this.renderItems(tile, partialTick, 0.0, 0.0, 0.0);
        GlStateManager.func_179121_F();
    }

    public void render(TileEntityOfferingAltar tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            this.renderTileAsItem(x, y, z);
            return;
        }
        this.renderTile(tile, x, y, z, partialTicks, destroyStage, alpha);
    }

    private void renderTileAsItem(double x, double y, double z) {
        GlStateManager.func_179094_E();
        this.func_147499_a(this.TEXTURE);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.MODEL.render();
        GlStateManager.func_179121_F();
    }

    private void renderItems(TileEntityOfferingAltar tile, float partialTick, double x, double y, double z) {
        float angle = tile.time;
        if (tile.func_70301_a(3).func_190926_b()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.75, (double)0.0);
            for (int i = 0; i < 3; ++i) {
                ItemStack item = tile.func_70301_a(i);
                if (item.func_190926_b()) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(120.0f * (float)(i + 1) + (float)tile.func_145831_w().func_82737_E()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)Math.cos(Math.toRadians(angle)), (double)0.0, (double)0.0);
                this.func_147499_a(TextureMap.field_110575_b);
                if (item.func_77973_b() instanceof ItemBlock) {
                    GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
                } else {
                    GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(120.0f * (float)(i + 1) + (float)tile.func_145831_w().func_82737_E()), (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_175599_af().func_180454_a(item, Minecraft.func_71410_x().func_175599_af().func_184393_a(item, (World)null, (EntityLivingBase)null));
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
                double a = -Math.toRadians(120.0f * (float)(i + 1) + (float)tile.func_145831_w().func_82737_E() - 90.0f);
                double offSetX = -Math.sin(a) * Math.cos(Math.toRadians(angle));
                double offSetZ = Math.cos(a) * Math.cos(Math.toRadians(angle));
                if (tile.func_145831_w().func_82737_E() % 4L != 0L) continue;
                Erebus.PROXY.spawnCustomParticle(this.getParticleType(item.func_77973_b()), tile.func_145831_w(), (double)((float)tile.func_174877_v().func_177958_n() + 0.5f) - offSetX, (float)tile.func_174877_v().func_177956_o() + 1.5f + (tile.func_145831_w().field_73012_v.nextFloat() - tile.func_145831_w().field_73012_v.nextFloat()) * 0.1f, (double)((float)tile.func_174877_v().func_177952_p() + 0.5f) - offSetZ, 0.0, 0.0, 0.0);
            }
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
            GlStateManager.func_179114_b((float)tile.func_145831_w().func_82737_E(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            this.func_147499_a(TextureMap.field_110575_b);
            Minecraft.func_71410_x().func_175599_af().func_180454_a(tile.getItemForRendering(3), Minecraft.func_71410_x().func_175599_af().func_184393_a(tile.getItemForRendering(3), (World)null, (EntityLivingBase)null));
            GlStateManager.func_179121_F();
        }
    }

    public String getParticleType(Item itemIn) {
        if (itemIn == Item.func_150898_a((Block)Blocks.field_150343_Z)) {
            return "flame";
        }
        if (itemIn == Items.field_151045_i) {
            return "swampflame";
        }
        if (itemIn == Items.field_151166_bC) {
            return "swampflame_green";
        }
        return "flame";
    }
}

