/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.tile;

import erebus.client.model.block.ModelGlowingJar;
import erebus.tileentity.TileEntityGlowingJar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityGlowingJarRenderer
extends TileEntitySpecialRenderer<TileEntityGlowingJar> {
    private final ModelGlowingJar glowingJar = new ModelGlowingJar();
    private static final ResourceLocation GLOWING_JAR_TEXTURE = new ResourceLocation("erebus:textures/special/tiles/glowing_jar.png");
    private static final ResourceLocation WISP_TEXTURE = new ResourceLocation("erebus:entity/wisp");

    public void render(TileEntityGlowingJar tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            this.renderTileAsItem(x, y, z);
            return;
        }
        this.renderTile(tile, x, y, z, partialTicks, destroyStage, alpha);
    }

    public void renderTile(TileEntityGlowingJar tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y - (double)(tile.particleSize / 4.0f)), (double)(z + 0.5));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.setGLColorFromInt(-1277682);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float yMin = 0.0f;
        float xMax = 0.5f;
        float zMax = 0.0f;
        float xMin = -0.5f;
        float zMin = 0.0f;
        yMin = 0.5f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179114_b((float)(180.0f + Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(WISP_TEXTURE.toString());
        GlStateManager.func_179152_a((float)(tile.particleSize / 3.0f + 0.5f), (float)(tile.particleSize / 3.0f + 0.5f), (float)(tile.particleSize / 3.0f + 0.5f));
        this.renderQuads(buffer, xMax, xMin, yMin, 1.0f, zMin, zMax, texture);
        tessellator.func_78381_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        this.func_147499_a(GLOWING_JAR_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)0.7125f, (float)-0.9999f, (float)-0.7125f);
        GlStateManager.func_179129_p();
        this.glowingJar.render();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private void renderQuads(BufferBuilder buffer, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite) {
        double uMin = textureAtlasSprite.func_94209_e();
        double uMax = textureAtlasSprite.func_94212_f();
        double vMin = textureAtlasSprite.func_94206_g();
        double vMax = textureAtlasSprite.func_94210_h();
        double vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMax, vMin);
    }

    private void addVertexWithUV(BufferBuilder buffer, float x, float y, float z, double u, double v) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_187315_a(u, v).func_181675_d();
    }

    public void renderTileAsItem(double x, double y, double z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y - (double)0.35f), (double)(z + 0.5));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.setGLColorFromInt(-1277682);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float yMin = 0.0f;
        float xMax = 0.5f;
        float zMax = 0.0f;
        float xMin = -0.5f;
        float zMin = 0.0f;
        yMin = 0.5f;
        GlStateManager.func_179091_B();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(WISP_TEXTURE.toString());
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderQuads(buffer, xMax, xMin, yMin, 1.0f, zMin, zMax, texture);
        tessellator.func_78381_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        this.func_147499_a(GLOWING_JAR_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.51f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)0.7125f, (float)-0.9999f, (float)-0.7125f);
        GlStateManager.func_179129_p();
        this.glowingJar.render();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }
}

