/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.items.ItemMaterials;
import erebus.items.block.ItemBlockEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSmallPlant
extends BlockBush
implements IGrowable,
IShearable,
ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumSmallPlantType> PLANT_TYPE = PropertyEnum.func_177709_a((String)"type", EnumSmallPlantType.class);

    public BlockSmallPlant() {
        super(Material.field_151582_l);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(ModTabs.PLANTS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PLANT_TYPE, (Comparable)((Object)EnumSmallPlantType.NETTLE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLANT_TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.PLANTS) {
            for (EnumSmallPlantType type : EnumSmallPlantType.values()) {
                list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.FIRE_BLOOM) {
            world.func_175688_a(EnumParticleTypes.FLAME, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PLANT_TYPE, (Comparable)((Object)EnumSmallPlantType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumSmallPlantType type = (EnumSmallPlantType)((Object)state.func_177229_b(PLANT_TYPE));
        return type.ordinal();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((EnumSmallPlantType)((Object)state.func_177229_b(PLANT_TYPE))).ordinal());
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (rand.nextInt(25) == 0) {
            BlockPos newPos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            int xx = pos.func_177958_n() + rand.nextInt(3) - 1;
            int yy = pos.func_177956_o() + rand.nextInt(2) - rand.nextInt(2);
            int zz = pos.func_177952_p() + rand.nextInt(3) - 1;
            if (world.func_175623_d(newPos) && this.func_180671_f(world, newPos, state)) {
                if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.NETTLE && rand.nextInt(3) == 0) {
                    world.func_175656_a(newPos, this.func_176223_P().func_177226_a(PLANT_TYPE, (Comparable)((Object)EnumSmallPlantType.NETTLE_FLOWERED)));
                }
                if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.NETTLE_FLOWERED) {
                    world.func_175656_a(newPos, this.func_176223_P().func_177226_a(PLANT_TYPE, (Comparable)((Object)EnumSmallPlantType.NETTLE)));
                }
            }
        }
    }

    public NonNullList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.NETTLE) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.NETTLE_LEAVES.ordinal()));
        }
        if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.NETTLE_FLOWERED) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.NETTLE_FLOWERS.ordinal()));
        }
        if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.SWAMP_PLANT) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack(ModItems.CABBAGE_SEEDS, 1, 0));
        }
        if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.DESERT_SHRUB) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, this.func_176201_c(state)));
        }
        if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.FIRE_BLOOM) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, this.func_176201_c(state)));
        }
        if (state.func_177229_b(PLANT_TYPE) == EnumSmallPlantType.FIDDLE_HEAD) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack(Items.field_151081_bc));
        }
        return NonNullList.func_191196_a();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack(ModBlocks.SMALL_PLANT, 1, ((EnumSmallPlantType)((Object)world.func_180495_p(pos).func_177229_b(PLANT_TYPE))).ordinal()));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create((Block)this, EnumSmallPlantType.class);
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumSmallPlantType type : EnumSmallPlantType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumSmallPlantType implements IErebusEnum
    {
        NETTLE,
        NETTLE_FLOWERED,
        SWAMP_PLANT,
        DESERT_SHRUB,
        FIRE_BLOOM,
        FIDDLE_HEAD,
        FERN;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.SMALL_PLANT, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

