/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.items.ItemMaterials;
import erebus.items.block.ItemBlockEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedGem
extends Block
implements ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public BlockRedGem() {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149715_a(1.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(ModTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.RED_GEM)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.BLOCKS) {
            for (EnumType type : EnumType.values()) {
                list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
            }
        }
    }

    public NonNullList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(TYPE) == EnumType.RED_LAMP_ON || state.func_177229_b(TYPE) == EnumType.RED_LAMP_OFF) {
            return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, EnumType.RED_LAMP_ON.ordinal()));
        }
        if (state.func_177229_b(TYPE) == EnumType.RED_GEM) {
            return NonNullList.func_191197_a((int)(1 + RANDOM.nextInt(2 + fortune)), (Object)ItemMaterials.EnumErebusMaterialsType.RED_GEM.createStack());
        }
        return NonNullList.func_191196_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return state.func_177229_b(TYPE) != EnumType.RED_LAMP_ON;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(TYPE) == EnumType.RED_GEM || state.func_177229_b(TYPE) == EnumType.RED_LAMP_ON) {
            return 15;
        }
        return 0;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            if (state.func_177229_b(TYPE) == EnumType.RED_LAMP_OFF && !world.func_175640_z(pos)) {
                world.func_180497_b(pos, (Block)this, 0, 4);
            } else if (state.func_177229_b(TYPE) == EnumType.RED_LAMP_ON && world.func_175640_z(pos)) {
                world.func_180501_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.RED_LAMP_OFF)), 2);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (state.func_177229_b(TYPE) == EnumType.RED_LAMP_OFF && !world.func_175640_z(pos)) {
                world.func_180501_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.RED_LAMP_ON)), 2);
                world.func_175684_a(pos, (Block)this, 4);
            } else if (state.func_177229_b(TYPE) == EnumType.RED_LAMP_ON && world.func_175640_z(pos)) {
                world.func_180501_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.RED_LAMP_OFF)), 2);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && state.func_177229_b(TYPE) == EnumType.RED_LAMP_OFF && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.RED_LAMP_ON)), 2);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create(this, EnumType.class);
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumType type : EnumType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumType implements IErebusEnum
    {
        RED_GEM,
        RED_LAMP_OFF,
        RED_LAMP_ON;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.RED_GEM, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

