/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.items.ItemMaterials;
import erebus.items.block.ItemBlockEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDoubleHeightPlant
extends BlockBush
implements IGrowable,
IShearable,
ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumPlantType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumPlantType.class);
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumBlockHalf.class);

    public BlockDoubleHeightPlant() {
        super(Material.field_151582_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumPlantType.BULLRUSH)).func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(ModTabs.PLANTS);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    private EnumPlantType getType(IBlockAccess blockAccess, BlockPos pos, IBlockState state) {
        state = state.func_185899_b(blockAccess, pos);
        return (EnumPlantType)((Object)state.func_177229_b(VARIANT));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m && world.func_175623_d(pos.func_177984_a()) ? true : super.func_176196_c(world, pos) && world.func_175623_d(pos.func_177984_a());
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }

    protected void func_176475_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(world, pos, state)) {
            BlockDoubleHeightPlant block1;
            boolean flag = state.func_177229_b(HALF) == EnumBlockHalf.UPPER;
            BlockPos blockpos = flag ? pos : pos.func_177984_a();
            BlockPos blockpos1 = flag ? pos.func_177977_b() : pos;
            BlockDoubleHeightPlant block = flag ? this : world.func_180495_p(blockpos).func_177230_c();
            BlockDoubleHeightPlant blockDoubleHeightPlant = block1 = flag ? world.func_180495_p(blockpos1).func_177230_c() : this;
            if (!flag) {
                this.func_176226_b(world, pos, state, 0);
            }
            if (block == this) {
                world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            if (block1 == this) {
                world.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState iblockstateDown = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return iblockstateDown.func_177230_c() == Blocks.field_150354_m ? true : (iblockstateDown.func_177230_c() == ModBlocks.MUD ? true : super.func_180671_f(world, pos, state));
        }
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        IBlockState iblockstate = world.func_180495_p(pos.func_177984_a());
        return iblockstate.func_177230_c() == this && iblockstateDown.func_177230_c() == Blocks.field_150354_m ? true : (iblockstate.func_177230_c() == this && iblockstateDown.func_177230_c() == ModBlocks.MUD ? true : iblockstate.func_177230_c() == this && super.func_180671_f(world, pos, iblockstate));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            return Items.field_190931_a;
        }
        EnumPlantType planttype = (EnumPlantType)((Object)state.func_177229_b(VARIANT));
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumPlantType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public void placeAt(World world, BlockPos lowerPos, EnumPlantType variant, int flags) {
        world.func_180501_a(lowerPos, this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)).func_177226_a(VARIANT, (Comparable)((Object)variant)), flags);
        world.func_180501_a(lowerPos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)), flags);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)), 2);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            IBlockState iblockstate = world.func_180495_p(pos.func_177977_b());
            ret.add(new ItemStack(iblockstate.func_177230_c().func_180660_a(iblockstate, RANDOM, fortune)));
        } else if (state.func_177229_b(VARIANT) == EnumPlantType.SUNDEW) {
            ret.add(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.BIO_LUMINESCENCE.ordinal()));
        } else if (state.func_177229_b(VARIANT) == EnumPlantType.WEEPING_BLUEBELL) {
            ret.add(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.BLUEBELL_PETAL.ordinal()));
        } else if (state.func_177229_b(VARIANT) == EnumPlantType.BULLRUSH) {
            ret.add(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.PAPYRUS.ordinal()));
        } else if (state.func_177229_b(VARIANT) == EnumPlantType.TALL_BLOOM) {
            ret.add(new ItemStack((Block)this, 1, this.func_176201_c(state)));
        } else if (state.func_177229_b(VARIANT) == EnumPlantType.TANGLED_STALK_MUSHROOM) {
            ret.add(new ItemStack((Block)this, 1, this.func_176201_c(state)));
        } else if (state.func_177229_b(VARIANT) == EnumPlantType.HIGH_CAPPED_MUSHROOM) {
            ret.add(new ItemStack((Block)this, 1, this.func_176201_c(state)));
        } else {
            ItemStack seed = ForgeHooks.getGrassSeed((Random)RANDOM, (int)fortune);
            if (!seed.func_190926_b()) {
                ret.add(seed);
            } else {
                ret.add(new ItemStack((Block)this, 1, this.func_176201_c(state)));
            }
        }
        return ret;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                if (player.field_71075_bZ.field_75098_d) {
                    world.func_175698_g(pos.func_177977_b());
                } else {
                    IBlockState iblockstate = world.func_180495_p(pos.func_177977_b());
                    EnumPlantType planttype = (EnumPlantType)((Object)iblockstate.func_177229_b(VARIANT));
                    world.func_175655_b(pos.func_177977_b(), RANDOM.nextInt(5) == 0);
                    if (world.field_72995_K) {
                        world.func_175698_g(pos.func_177977_b());
                    } else if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == Items.field_151097_aZ) {
                        this.onHarvest(world, pos, iblockstate, player);
                        world.func_175698_g(pos.func_177977_b());
                    }
                }
            }
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
        }
        super.func_176208_a(world, pos, state, player);
    }

    private boolean onHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.PLANTS) {
            for (EnumPlantType planttype : EnumPlantType.values()) {
                list.add((Object)new ItemStack((Block)this, 1, planttype.ordinal()));
            }
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, this.getType((IBlockAccess)world, pos, state).ordinal());
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockDoubleHeightPlant.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, this.getType((IBlockAccess)world, pos, state).ordinal()));
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.UPPER)) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumBlockHalf.LOWER)).func_177226_a(VARIANT, (Comparable)((Object)EnumPlantType.values()[meta & 7]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b(HALF) == EnumBlockHalf.UPPER && (iblockstate = world.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
            state = state.func_177226_a(VARIANT, iblockstate.func_177229_b(VARIANT));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(HALF) == EnumBlockHalf.UPPER ? 8 | ((EnumPlantType)((Object)state.func_177229_b(VARIANT))).ordinal() : ((EnumPlantType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, VARIANT});
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        EnumPlantType type = (EnumPlantType)((Object)state.func_177229_b(VARIANT));
        return state.func_177229_b(HALF) == EnumBlockHalf.LOWER;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        EnumPlantType type = (EnumPlantType)((Object)world.func_180495_p(pos).func_177229_b(VARIANT));
        ret.add(new ItemStack((Block)this, 1, type.ordinal() & 7));
        return ret;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (state.func_177230_c() == this && state.func_177229_b(HALF) == EnumBlockHalf.LOWER && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_175698_g(pos.func_177984_a());
        }
        return world.func_175698_g(pos);
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create((Block)this, EnumPlantType.class);
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumPlantType type : EnumPlantType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumPlantType implements IStringSerializable
    {
        BULLRUSH,
        WEEPING_BLUEBELL,
        SUNDEW,
        DROUGHTED_SHRUB,
        TALL_BLOOM,
        TANGLED_STALK_MUSHROOM,
        HIGH_CAPPED_MUSHROOM;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum EnumBlockHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

