/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModTabs;
import erebus.core.helper.Utils;
import erebus.tileentity.TileEntityBones;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBones
extends BlockDirectional
implements ITileEntityProvider {
    protected static final AxisAlignedBB BONES_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0);

    public BlockBones() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(ModTabs.BLOCKS);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BONES_AABB.func_191194_a(state.func_191059_e(source, pos));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BONES_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBones();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        return meta |= ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)BlockBones.getFacingFromEntity(pos, placer));
    }

    public static EnumFacing getFacingFromEntity(BlockPos pos, EntityLivingBase entity) {
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double eyeHeight = entity.field_70163_u + (double)entity.func_70047_e();
            if (eyeHeight - (double)pos.func_177956_o() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)pos.func_177956_o() - eyeHeight > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return entity.func_174811_aO().func_176734_d();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IInventory tile = Utils.getTileEntity((IBlockAccess)world, pos, IInventory.class);
        if (tile != null) {
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack stack = tile.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                Utils.dropStack(world, pos, stack);
            }
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_189880_di.func_176223_P()));
        super.func_180663_b(world, pos, state);
    }
}

