/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.silo;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.block.silo.TileEntitySiloTank;
import erebus.core.helper.Utils;
import erebus.items.block.ItemBlockEnum;
import erebus.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSiloTank
extends BlockContainer
implements ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumSiloType> ACTIVE = PropertyEnum.func_177709_a((String)"active", EnumSiloType.class);
    protected static final AxisAlignedBB SILO_TANK_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockSiloTank(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ACTIVE, (Comparable)((Object)EnumSiloType.SILO_INACTIVE)));
        this.func_149647_a(ModTabs.BLOCKS);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SILO_TANK_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return SILO_TANK_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity tile;
        if (this.isSiloComplete(world, pos) && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntitySiloTank) {
            ((TileEntitySiloTank)tile).setActive(true);
            world.func_180501_a(pos, this.func_176223_P().func_177226_a(ACTIVE, (Comparable)((Object)EnumSiloType.SILO_ACTIVE)), 3);
            return;
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity tile;
        if (this.isSiloComplete(world, pos)) {
            TileEntity tile2 = world.func_175625_s(pos);
            if (tile2 != null && tile2 instanceof TileEntitySiloTank) {
                ((TileEntitySiloTank)tile2).setActive(true);
                world.func_180501_a(pos, this.func_176223_P().func_177226_a(ACTIVE, (Comparable)((Object)EnumSiloType.SILO_ACTIVE)), 3);
            }
        } else if (!this.isSiloComplete(world, pos) && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntitySiloTank) {
            ((TileEntitySiloTank)tile).setActive(false);
            world.func_180501_a(pos, this.func_176223_P().func_177226_a(ACTIVE, (Comparable)((Object)EnumSiloType.SILO_INACTIVE)), 3);
            this.func_180663_b(world, pos, state);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntitySiloTank) {
            ItemStack current = player.field_71071_by.func_70448_g();
            if (!current.func_190926_b() && current.func_77973_b() == Item.func_150898_a((Block)ModBlocks.SILO_ROOF)) {
                return false;
            }
            if (this.isSiloComplete(world, pos)) {
                player.openGui((Object)Erebus.INSTANCE, CommonProxy.GuiID.SILO_INVENTORY.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
        }
        return true;
    }

    public boolean isSiloComplete(World world, BlockPos pos) {
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
        return stateDown.func_177230_c() == ModBlocks.SILO_SUPPORTS && stateUp.func_177230_c() == ModBlocks.SILO_ROOF;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.SILO_SUPPORTS;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntitySiloTank tile = Utils.getTileEntity((IBlockAccess)world, pos, TileEntitySiloTank.class);
        if (tile != null) {
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack is = tile.func_70301_a(i);
                if (is.func_190926_b()) continue;
                Utils.dropStack(world, pos, is);
            }
        }
        world.func_175698_g(pos);
        super.func_180663_b(world, pos, state);
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySiloTank();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.BLOCKS) {
            list.add((Object)new ItemStack((Block)this, 1, EnumSiloType.SILO_INACTIVE.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ACTIVE, (Comparable)((Object)EnumSiloType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumSiloType type = (EnumSiloType)((Object)state.func_177229_b(ACTIVE));
        return type.ordinal();
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create((Block)this, EnumSiloType.class);
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumSiloType type : EnumSiloType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumSiloType implements IErebusEnum
    {
        SILO_INACTIVE,
        SILO_ACTIVE;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.SILO_TANK, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

