/*
 * Decompiled with CFR 0.152.
 */
package erebus;

import erebus.ModItems;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModFluids {
    public static final ModFluids INSTANCE = new ModFluids();
    public static Fluid HONEY = new Fluid("honey", new ResourceLocation("erebus", "fluids/honey_still"), new ResourceLocation("erebus", "fluids/honey_flow")).setDensity(6000).setViscosity(6000).setUnlocalizedName("honey");
    public static Fluid ANTI_VENOM = new Fluid("anti_venom", new ResourceLocation("erebus", "fluids/anti_venom_still"), new ResourceLocation("erebus", "fluids/anti_venom_flow")).setViscosity(2000).setUnlocalizedName("anti_venom");
    public static Fluid BEETLE_JUICE = new Fluid("beetle_juice", new ResourceLocation("erebus", "fluids/beetle_juice_still"), new ResourceLocation("erebus", "fluids/beetle_juice_flow")).setUnlocalizedName("beetle_juice");
    public static Fluid MILK = new Fluid("milk", new ResourceLocation("erebus", "fluids/milk_still"), new ResourceLocation("erebus", "fluids/milk_flow")).setUnlocalizedName("milk");
    public static Fluid FORMIC_ACID = new Fluid("formic_acid", new ResourceLocation("erebus", "fluids/formic_acid_still"), new ResourceLocation("erebus", "fluids/formic_acid_flow")).setUnlocalizedName("formic_acid");

    private ModFluids() {
    }

    public static void init() {
        try {
            for (Field f : ModFluids.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Fluid)) continue;
                Fluid fluid = (Fluid)obj;
                if (FluidRegistry.isFluidRegistered((String)fluid.getName())) {
                    f.set(null, FluidRegistry.getFluid((String)fluid.getName()));
                    continue;
                }
                FluidRegistry.registerFluid((Fluid)fluid);
                FluidRegistry.addBucketForFluid((Fluid)fluid);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static ItemStack getFilledBambucket(@Nonnull FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (FluidRegistry.getBucketFluids().contains(fluid)) {
            ItemStack filledBucket = new ItemStack(ModItems.BAMBUCKET);
            IFluidHandlerItem cap = (IFluidHandlerItem)filledBucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            cap.fill(fluidStack, true);
            return filledBucket;
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(HONEY.getStill());
        event.getMap().func_174942_a(HONEY.getFlowing());
        event.getMap().func_174942_a(ANTI_VENOM.getStill());
        event.getMap().func_174942_a(ANTI_VENOM.getFlowing());
        event.getMap().func_174942_a(BEETLE_JUICE.getStill());
        event.getMap().func_174942_a(BEETLE_JUICE.getFlowing());
        event.getMap().func_174942_a(FORMIC_ACID.getStill());
        event.getMap().func_174942_a(FORMIC_ACID.getFlowing());
        event.getMap().func_174942_a(MILK.getStill());
        event.getMap().func_174942_a(MILK.getFlowing());
    }
}

