/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.inv.capabilities;

import CoroUtil.difficulty.data.spawns.DataActionMobSpawns;
import CoroUtil.difficulty.data.spawns.DataMobSpawnsTemplate;
import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilEntity;
import com.corosus.inv.InvLog;
import com.corosus.inv.InvasionEntitySpawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class PlayerDataInstance {
    private List<InvasionEntitySpawn> listSpawnables = new ArrayList<InvasionEntitySpawn>();
    private EntityPlayer player;
    private float difficultyForInvasion = 0.0f;
    public boolean dataPlayerInvasionHappenedThisDay;
    public boolean dataPlayerInvasionActive;
    public boolean dataPlayerInvasionWarned;
    public boolean allowSpawnInLitAreas = false;
    private List<Class> listSpawnablesCached = new ArrayList<Class>();
    public List<BlockPos> listGoodCavePositions = new ArrayList<BlockPos>();
    public int triesSinceWorkingCaveSpawn = 0;
    public int triesSinceWorkingAnySpawn = 0;
    public int triesSinceWorkingSolidGroundSpawn = 0;
    public int lastWaveNumber = 0;

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public PlayerDataInstance setPlayer(EntityPlayer player) {
        this.player = player;
        return this;
    }

    public void initNewInvasion(DataMobSpawnsTemplate profile) {
        InvLog.dbg("init invasion spawn template to runtime data");
        if (profile.spawns.size() > 0) {
            for (DataActionMobSpawns spawns : profile.spawns) {
                InvasionEntitySpawn newSpawn = new InvasionEntitySpawn();
                newSpawn.spawnProfile = spawns.copy();
                InvLog.dbg("adding spawns: " + newSpawn.toString(true));
                this.listSpawnables.add(newSpawn);
            }
        } else {
            InvLog.dbg("CRITICAL: there was no spawn data to setup!");
        }
    }

    public void stopInvasion() {
        this.resetInvasion();
    }

    public void resetInvasion() {
        InvLog.dbg("resetInvasion()");
        for (InvasionEntitySpawn spawns : this.listSpawnables) {
            spawns.clear();
        }
        this.listSpawnables.clear();
        this.listSpawnablesCached.clear();
        this.allowSpawnInLitAreas = false;
        this.listGoodCavePositions.clear();
        this.triesSinceWorkingCaveSpawn = 0;
        this.triesSinceWorkingAnySpawn = 0;
        this.triesSinceWorkingSolidGroundSpawn = 0;
    }

    public void resetPersistentData() {
        this.lastWaveNumber = 0;
    }

    public InvasionEntitySpawn getRandomEntityClassToSpawn() {
        ArrayList<InvasionEntitySpawn> listSpawnablesTry = new ArrayList<InvasionEntitySpawn>();
        for (InvasionEntitySpawn spawns : this.listSpawnables) {
            if (spawns.spawnCountCurrent >= spawns.spawnProfile.getMaxMobCountDynamic((double)this.difficultyForInvasion) || spawns.spawnProfile.entities.size() <= 0) continue;
            listSpawnablesTry.add(spawns);
        }
        Random random = new Random();
        if (listSpawnablesTry.size() > 0) {
            InvasionEntitySpawn spawn = (InvasionEntitySpawn)listSpawnablesTry.get(random.nextInt(listSpawnablesTry.size()));
            InvLog.dbg("returning this to spawn in: " + spawn.toString());
            return spawn;
        }
        if (this.listSpawnables.size() <= 0) {
            InvLog.dbg("nothing to spawn and there was never anything to choose from, nothing to invade, this is bad?");
        }
        return null;
    }

    public List<Class> getSpawnableClasses() {
        if (this.listSpawnablesCached.size() == 0) {
            for (InvasionEntitySpawn spawns : this.listSpawnables) {
                for (String spawnable : spawns.spawnProfile.entities) {
                    Class classToSpawn = CoroUtilEntity.getClassFromRegistry((String)spawnable);
                    if (classToSpawn == null || this.listSpawnablesCached.contains(classToSpawn)) continue;
                    this.listSpawnablesCached.add(classToSpawn);
                }
            }
        }
        return this.listSpawnablesCached;
    }

    public void readNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound nbt = nbtTagCompound.func_74775_l("spawns");
        for (String tagName : nbt.func_150296_c()) {
            NBTTagCompound nbtEntry = nbt.func_74775_l(tagName);
            InvasionEntitySpawn spawn = new InvasionEntitySpawn();
            spawn.readNBT(nbtEntry);
            this.listSpawnables.add(spawn);
        }
        this.dataPlayerInvasionHappenedThisDay = nbtTagCompound.func_74767_n("dataPlayerInvasionHappenedThisDay");
        this.dataPlayerInvasionActive = nbtTagCompound.func_74767_n("dataPlayerInvasionActive");
        this.dataPlayerInvasionWarned = nbtTagCompound.func_74767_n("dataPlayerInvasionWarned");
        this.allowSpawnInLitAreas = nbtTagCompound.func_74767_n("allowSpawnInLitAreas");
        this.difficultyForInvasion = nbtTagCompound.func_74760_g("difficultyForInvasion");
        this.lastWaveNumber = nbtTagCompound.func_74762_e("lastWaveNumber");
        CULog.dbg((String)"read done");
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.listSpawnables.size(); ++i) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            InvasionEntitySpawn spawn = this.listSpawnables.get(i);
            spawn.writeNBT(nbtEntry);
            nbt.func_74782_a("spawn_" + i, (NBTBase)nbtEntry);
        }
        nbtTagCompound.func_74782_a("spawns", (NBTBase)nbt);
        nbtTagCompound.func_74757_a("dataPlayerInvasionHappenedThisDay", this.dataPlayerInvasionHappenedThisDay);
        nbtTagCompound.func_74757_a("dataPlayerInvasionActive", this.dataPlayerInvasionActive);
        nbtTagCompound.func_74757_a("dataPlayerInvasionWarned", this.dataPlayerInvasionWarned);
        nbtTagCompound.func_74757_a("allowSpawnInLitAreas", this.allowSpawnInLitAreas);
        nbtTagCompound.func_74776_a("difficultyForInvasion", this.difficultyForInvasion);
        nbtTagCompound.func_74768_a("lastWaveNumber", this.lastWaveNumber);
    }

    public void copyRuntimeData(PlayerDataInstance oldInstance) {
        this.listGoodCavePositions.addAll(oldInstance.listGoodCavePositions);
        this.listSpawnablesCached.addAll(oldInstance.listSpawnablesCached);
        this.triesSinceWorkingCaveSpawn = oldInstance.triesSinceWorkingCaveSpawn;
        this.triesSinceWorkingAnySpawn = oldInstance.triesSinceWorkingAnySpawn;
        this.triesSinceWorkingSolidGroundSpawn = oldInstance.triesSinceWorkingSolidGroundSpawn;
    }

    public float getDifficultyForInvasion() {
        return this.difficultyForInvasion;
    }

    public void setDifficultyForInvasion(float difficultyForInvasion) {
        this.difficultyForInvasion = difficultyForInvasion;
    }
}

