/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.inv;

import CoroUtil.block.TileEntityRepairingBlock;
import CoroUtil.config.ConfigDynamicDifficulty;
import CoroUtil.difficulty.UtilEntityBuffs;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilWorldTime;
import CoroUtil.util.UtilMining;
import com.corosus.inv.Invasion;
import com.corosus.inv.InvasionManager;
import com.corosus.inv.capabilities.PlayerDataInstance;
import com.corosus.inv.config.ConfigAdvancedOptions;
import com.corosus.inv.config.ConfigInvasion;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandlerForge {
    @SubscribeEvent
    public void onAttachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("hw_inv", "PlayerDataInstance"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                PlayerDataInstance instance;
                {
                    this.instance = ((PlayerDataInstance)Invasion.PLAYER_DATA_INSTANCE.getDefaultInstance()).setPlayer((EntityPlayer)event.getObject());
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == Invasion.PLAYER_DATA_INSTANCE;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == Invasion.PLAYER_DATA_INSTANCE ? Invasion.PLAYER_DATA_INSTANCE.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)Invasion.PLAYER_DATA_INSTANCE.getStorage().writeNBT(Invasion.PLAYER_DATA_INSTANCE, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    Invasion.PLAYER_DATA_INSTANCE.getStorage().readNBT(Invasion.PLAYER_DATA_INSTANCE, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void canSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        if (ConfigInvasion.preventSleepDuringInvasions && InvasionManager.shouldLockOutFeaturesForPossibleActiveInvasion(player.field_70170_p)) {
            player.func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_cantSleep));
            event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public void canTeleportDimensions(EntityTravelToDimensionEvent event) {
        if (ConfigInvasion.preventDimensionTeleportingDuringInvasions && event.getEntity() instanceof EntityPlayer && CoroUtilWorldTime.isNightPadded((World)event.getEntity().field_70170_p) && InvasionManager.isInvasionTonight(event.getEntity().field_70170_p) && !InvasionManager.isPlayerSkippingInvasion((EntityPlayer)event.getEntity()) && event.getDimension() != 0) {
            event.getEntity().func_145747_a((ITextComponent)new TextComponentString(ConfigInvasion.Invasion_Message_cantTeleport));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void canDespawn(LivingSpawnEvent.AllowDespawn event) {
        if (CoroUtilWorldTime.isNightPadded((World)event.getEntity().field_70170_p) && InvasionManager.isInvasionTonight(event.getEntity().field_70170_p) && event.getEntity().getEntityData().func_74767_n(UtilEntityBuffs.dataEntityWaveSpawned)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        WorldServer world;
        if (event.phase == TickEvent.Phase.START && (world = DimensionManager.getWorld((int)0)) != null) {
            if (world.func_82737_E() % 20L == 0L) {
                for (EntityPlayer player : world.field_73010_i) {
                    if (!CoroUtilEntity.canProcessForList((String)CoroUtilEntity.getName((Entity)player), (String)ConfigAdvancedOptions.blackListPlayers, (boolean)ConfigAdvancedOptions.useBlacklistAsWhitelist)) continue;
                    InvasionManager.tickPlayerSlowPre(player);
                }
                for (EntityPlayer player : world.field_73010_i) {
                    if (!CoroUtilEntity.canProcessForList((String)CoroUtilEntity.getName((Entity)player), (String)ConfigAdvancedOptions.blackListPlayers, (boolean)ConfigAdvancedOptions.useBlacklistAsWhitelist)) continue;
                    InvasionManager.tickPlayerSlow(player);
                }
            }
            for (EntityPlayer player : world.field_73010_i) {
                if (!CoroUtilEntity.canProcessForList((String)CoroUtilEntity.getName((Entity)player), (String)ConfigAdvancedOptions.blackListPlayers, (boolean)ConfigAdvancedOptions.useBlacklistAsWhitelist)) continue;
                InvasionManager.tickPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public void playerCloneEvent(PlayerEvent.Clone event) {
        PlayerDataInstance oldInstance = (PlayerDataInstance)event.getOriginal().getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
        PlayerDataInstance newInstance = (PlayerDataInstance)event.getEntityPlayer().getCapability(Invasion.PLAYER_DATA_INSTANCE, null);
        NBTTagCompound nbtOld = new NBTTagCompound();
        oldInstance.writeNBT(nbtOld);
        newInstance.readNBT(nbtOld);
        newInstance.copyRuntimeData(oldInstance);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void explosionEvent(ExplosionEvent.Detonate event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if ((ConfigDynamicDifficulty.convertExplodedBlocksToRepairingBlocksDuringInvasion || ConfigDynamicDifficulty.preventExplodedTileEntitiesDuringInvasions) && InvasionManager.shouldLockOutFeaturesForPossibleActiveInvasion(event.getWorld())) {
            List listPos = event.getExplosion().func_180343_e();
            Iterator it = listPos.iterator();
            while (it.hasNext()) {
                BlockPos pos = (BlockPos)it.next();
                if (ConfigDynamicDifficulty.preventExplodedTileEntitiesDuringInvasions && event.getWorld().func_175625_s(pos) != null) {
                    it.remove();
                    continue;
                }
                if (!ConfigDynamicDifficulty.convertExplodedBlocksToRepairingBlocksDuringInvasion) continue;
                IBlockState state = event.getWorld().func_180495_p(pos);
                if (!UtilMining.canMineBlock((World)event.getWorld(), (BlockPos)pos, (Block)state.func_177230_c()) || !UtilMining.canConvertToRepairingBlock((World)event.getWorld(), (IBlockState)state)) continue;
                TileEntityRepairingBlock.replaceBlockAndBackup((World)event.getWorld(), (BlockPos)pos);
                it.remove();
            }
        }
    }

    @SubscribeEvent
    public void entityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase ent = event.getEntityLiving();
        if (!ent.field_70170_p.field_72995_K && ConfigInvasion.damagePerSecondToInvadersAtSunrise > 0.0 && ent.field_70170_p.func_72935_r() && ent.getEntityData().func_74767_n(UtilEntityBuffs.dataEntityWaveSpawned) && (ent.field_70170_p.func_82737_E() + (long)ent.func_145782_y()) % 20L == 0L) {
            ent.func_70097_a(DamageSource.field_76380_i, (float)ConfigInvasion.damagePerSecondToInvadersAtSunrise);
            ent.func_70015_d(1);
        }
    }
}

