/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.entity;

import net.minecraft.entity.Entity;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamEntity;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickAddMotion
extends PieceTrick {
    public static final double MULTIPLIER = 0.3;
    SpellParam target;
    SpellParam direction;
    SpellParam speed;

    public PieceTrickAddMotion(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.target = new ParamEntity("psi.spellparam.target", SpellParam.YELLOW, false, false);
        this.addParam(this.target);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, false, false);
        this.addParam(this.direction);
        this.speed = new ParamNumber("psi.spellparam.speed", SpellParam.RED, false, true);
        this.addParam(this.speed);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double speedVal = (Double)this.getParamEvaluation(this.speed);
        if (speedVal == null) {
            speedVal = 1.0;
        }
        double absSpeed = Math.abs(speedVal);
        meta.addStat(EnumSpellStat.POTENCY, (int)this.multiplySafe(absSpeed, absSpeed, 3.5));
        meta.addStat(EnumSpellStat.COST, (int)this.multiplySafe(absSpeed, Math.max(1.0, absSpeed), 100.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Entity targetVal = (Entity)this.getParamValue(context, this.target);
        Vector3 directionVal = (Vector3)this.getParamValue(context, this.direction);
        Double speedVal = (Double)this.getParamValue(context, this.speed);
        PieceTrickAddMotion.addMotion(context, targetVal, directionVal, speedVal);
        return null;
    }

    public static void addMotion(SpellContext context, Entity e, Vector3 dir, double speed) throws SpellRuntimeException {
        String keyv;
        context.verifyEntity(e);
        if (!context.isInRadius(e)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        dir = dir.copy().normalize().multiply(0.3 * speed);
        String key = "psi:Entity" + e.func_145782_y() + "Motion";
        boolean added = false;
        if (Math.abs(dir.x) > 1.0E-4 && !context.customData.containsKey(keyv = key + "X")) {
            e.field_70159_w += dir.x;
            context.customData.put(keyv, 0);
            added = true;
        }
        if (Math.abs(dir.y) > 1.0E-4) {
            keyv = key + "Y";
            if (!context.customData.containsKey(keyv)) {
                e.field_70181_x += dir.y;
                context.customData.put(keyv, 0);
                added = true;
            }
            if (e.field_70181_x >= 0.0) {
                e.field_70143_R = 0.0f;
            }
        }
        if (Math.abs(dir.z) > 1.0E-4 && !context.customData.containsKey(keyv = key + "Z")) {
            e.field_70179_y += dir.z;
            context.customData.put(keyv, 0);
            added = true;
        }
        if (added && e != context.caster) {
            e.field_70133_I = true;
        }
    }
}

