/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.client.core.handler.HUDHandler;
import vazkii.psi.common.block.base.ModBlocks;

public class PieceTrickPlaceBlock
extends PieceTrick {
    SpellParam position;

    public PieceTrickPlaceBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 8);
        meta.addStat(EnumSpellStat.COST, 8);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        PieceTrickPlaceBlock.placeBlock(context.caster, context.caster.func_130014_f_(), pos, context.getTargetSlot(), false);
        return null;
    }

    public static void placeBlock(EntityPlayer player, World world, BlockPos pos, int slot, boolean particles) {
        PieceTrickPlaceBlock.placeBlock(player, world, pos, slot, particles, false);
    }

    public static void placeBlock(EntityPlayer player, World world, BlockPos pos, int slot, boolean particles, boolean conjure) {
        if (!world.func_175667_e(pos) || !world.func_175660_a(player, pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || block.func_176200_f((IBlockAccess)world, pos)) {
            if (conjure) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, ModBlocks.conjured.func_176223_P());
                }
            } else {
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock) {
                    ItemStack rem = PieceTrickPlaceBlock.removeFromInventory(player, stack);
                    ItemBlock iblock = (ItemBlock)rem.func_77973_b();
                    Block blockToPlace = Block.func_149634_a((Item)rem.func_77973_b());
                    if (!world.field_72995_K) {
                        IBlockState newState = blockToPlace.getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, rem.func_77952_i(), (EntityLivingBase)player, EnumHand.MAIN_HAND);
                        iblock.placeBlockAt(stack, player, world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, newState);
                    }
                    if (player.field_71075_bZ.field_75098_d) {
                        HUDHandler.setRemaining(rem, -1);
                    } else {
                        HUDHandler.setRemaining(player, rem, null);
                    }
                }
            }
            if (particles && !world.field_72995_K) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)world.func_180495_p(pos)));
            }
        }
    }

    public static ItemStack removeFromInventory(EntityPlayer player, ItemStack stack) {
        if (player.field_71075_bZ.field_75098_d) {
            return stack.func_77946_l();
        }
        InventoryPlayer inv = player.field_71071_by;
        for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack.func_190926_b() || !invStack.func_77969_a(stack) || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)invStack)) continue;
            ItemStack retStack = invStack.func_77946_l();
            invStack.func_190918_g(1);
            if (invStack.func_190916_E() == 0) {
                inv.func_70299_a(i, ItemStack.field_190927_a);
            }
            return retStack;
        }
        return ItemStack.field_190927_a;
    }
}

