/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.item.base.IPsiItem;

public interface IPsimetalTool
extends ISocketable,
ISpellSettable,
IPsiItem {
    public static final String TAG_BULLET_PREFIX = "bullet";
    public static final String TAG_SELECTED_SLOT = "selectedSlot";

    @Override
    default public boolean isSocketSlotAvailable(ItemStack stack, int slot) {
        return slot < 3;
    }

    @Override
    default public boolean showSlotInRadialMenu(ItemStack stack, int slot) {
        return this.isSocketSlotAvailable(stack, slot - 1);
    }

    @Override
    default public ItemStack getBulletInSocket(ItemStack stack, int slot) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)name, (boolean)true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cmp);
    }

    @Override
    default public void setBulletInSocket(ItemStack stack, int slot, ItemStack bullet) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = new NBTTagCompound();
        if (!bullet.func_190926_b()) {
            bullet.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound((ItemStack)stack, (String)name, (NBTTagCompound)cmp);
    }

    @Override
    default public int getSelectedSlot(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)0);
    }

    @Override
    default public void setSelectedSlot(ItemStack stack, int slot) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)slot);
    }

    @Override
    default public void setSpell(EntityPlayer player, ItemStack stack, Spell spell) {
        int slot = this.getSelectedSlot(stack);
        ItemStack bullet = this.getBulletInSocket(stack, slot);
        if (!bullet.func_190926_b() && bullet.func_77973_b() instanceof ISpellSettable) {
            ((ISpellSettable)bullet.func_77973_b()).setSpell(player, bullet, spell);
            this.setBulletInSocket(stack, slot, bullet);
        }
    }
}

