/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.arl.block.BlockFacing;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.base.IPsiBlock;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class BlockProgrammer
extends BlockFacing
implements IPsiBlock {
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");

    public BlockProgrammer() {
        super("programmer", Material.field_151573_f, new String[0]);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(PsiCreativeTab.INSTANCE);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumActionResult result;
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileProgrammer programmer = (TileProgrammer)worldIn.func_175625_s(pos);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(playerIn);
            if (data.spellGroupsUnlocked.isEmpty()) {
                if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a(new TextComponentTranslation("psimisc.cantUseProgrammer", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return true;
            }
        }
        if ((result = this.setSpell(worldIn, pos, playerIn, heldItem)) == EnumActionResult.SUCCESS) {
            return true;
        }
        boolean enabled = programmer.isEnabled();
        if (!enabled || programmer.playerLock.isEmpty()) {
            programmer.playerLock = playerIn.func_70005_c_();
        }
        if (playerIn instanceof EntityPlayerMP) {
            VanillaPacketDispatcher.dispatchTEToPlayer((TileEntity)programmer, (EntityPlayerMP)playerIn);
        }
        playerIn.openGui((Object)Psi.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public EnumActionResult setSpell(World worldIn, BlockPos pos, EntityPlayer playerIn, ItemStack heldItem) {
        TileProgrammer programmer = (TileProgrammer)worldIn.func_175625_s(pos);
        boolean enabled = programmer.isEnabled();
        if (enabled && !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ISpellSettable && programmer.spell != null && (playerIn.func_70093_af() || !((ISpellSettable)heldItem.func_77973_b()).requiresSneakForSpellSet(heldItem))) {
            if (programmer.canCompile()) {
                ISpellSettable settable = (ISpellSettable)heldItem.func_77973_b();
                if (!worldIn.field_72995_K) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.bulletCreate, SoundCategory.BLOCKS, 0.5f, 1.0f);
                }
                programmer.spell.uuid = UUID.randomUUID();
                settable.setSpell(playerIn, heldItem, programmer.spell);
                if (playerIn instanceof EntityPlayerMP) {
                    VanillaPacketDispatcher.dispatchTEToPlayer((TileEntity)programmer, (EntityPlayerMP)playerIn);
                }
                return EnumActionResult.SUCCESS;
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.compileError, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public IBlockState makeDefaultState() {
        return super.makeDefaultState().func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false));
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        return state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(tile instanceof TileProgrammer && ((TileProgrammer)tile).isEnabled()));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ENABLED});
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumRarity getBlockRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileProgrammer();
    }
}

