/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.proxy;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.client.core.handler.HUDHandler;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.client.fx.FXSparkle;
import vazkii.psi.client.fx.FXWisp;
import vazkii.psi.client.render.entity.RenderSpellCircle;
import vazkii.psi.client.render.tile.RenderTileProgrammer;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PersistencyHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.proxy.CommonProxy;
import vazkii.psi.common.entity.EntitySpellCircle;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static boolean distanceLimit = true;
    private static boolean depthTest = true;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ShaderHandler.init();
        KeybindHandler.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileProgrammer.class, (TileEntitySpecialRenderer)new RenderTileProgrammer());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellCircle.class, RenderSpellCircle::new);
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void onLevelUp(int level) {
        HUDHandler.levelUp(level);
    }

    @Override
    public void savePersistency() {
        PersistencyHandler.save(PlayerDataHandler.get((EntityPlayer)this.getClientPlayer()).level);
    }

    @Override
    public Color getCADColor(ItemStack cadStack) {
        ICAD icad = (ICAD)cadStack.func_77973_b();
        return new Color(icad.getSpellColor(cadStack));
    }

    @Override
    public Color getColorizerColor(ItemStack colorizer) {
        ICADColorizer icc = (ICADColorizer)colorizer.func_77973_b();
        return new Color(icc.getColor(colorizer));
    }

    @Override
    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float motionx, float motiony, float motionz, float size, int m) {
        if (this.noParticles(world)) {
            return;
        }
        FXSparkle sparkle = new FXSparkle(world, x, y, z, size, r, g, b, m);
        sparkle.setSpeed(motionx, motiony, motionz);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)sparkle);
    }

    @Override
    public void setWispFXDistanceLimit(boolean limit) {
        distanceLimit = limit;
    }

    @Override
    public void setWispFXDepthTest(boolean test) {
        depthTest = test;
    }

    @Override
    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, float maxAgeMul) {
        if (this.noParticles(world)) {
            return;
        }
        FXWisp wisp = new FXWisp(world, x, y, z, size, r, g, b, distanceLimit, depthTest, maxAgeMul);
        wisp.setSpeed(motionx, motiony, motionz);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)wisp);
    }

    private boolean noParticles(World world) {
        if (!world.field_72995_K) {
            return true;
        }
        if (!ConfigHandler.useVanillaParticleLimiter) {
            return false;
        }
        float chance = 1.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
            chance = 0.6f;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
            chance = 0.2f;
        }
        return chance != 1.0f && !(Math.random() < (double)chance);
    }

    @Override
    public String localize(String key, Object ... arguments) {
        return I18n.func_135052_a((String)key, (Object[])arguments);
    }
}

