/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.TextureColoredTexture;

public class PatternTexture
extends TextureColoredTexture {
    public PatternTexture(ResourceLocation partTexture, ResourceLocation patternTexture, String spriteName) {
        super(partTexture, patternTexture, spriteName);
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        if (RenderUtil.alpha(pixel) == 0) {
            return pixel;
        }
        if (this.field_130223_c > this.addTextureWidth) {
            int texX = (int)((float)this.getX(pxCoord) * this.scale);
            int texY = (int)((float)this.getY(pxCoord) * this.scale);
            pxCoord = texY * this.addTextureWidth + texX;
        }
        int x = pxCoord % this.addTextureWidth;
        int y = pxCoord / this.addTextureHeight;
        int x2 = x - this.offsetX;
        int y2 = y - this.offsetY;
        if (x2 >= this.addTextureWidth || x2 < 0 || y2 >= this.addTextureHeight || y2 < 0) {
            return pixel;
        }
        if (x < this.addTextureWidth / 8 || x > this.addTextureWidth - this.addTextureWidth / 8 || y < this.addTextureHeight / 8 || y > this.addTextureHeight - this.addTextureHeight / 8) {
            return pixel;
        }
        int c = this.textureData[this.coord2(x2, y2)];
        int a = RenderUtil.alpha(c);
        if (a < 64) {
            return pixel;
        }
        boolean edge = false;
        if (x > 0 && (a = RenderUtil.alpha(this.textureData[this.coord2(x - 1, y)])) < 64) {
            edge = true;
        }
        if (y < this.field_130224_d - 1 && (a = RenderUtil.alpha(this.textureData[this.coord2(x, y + 1)])) < 64) {
            edge = true;
        }
        if (x < this.field_130223_c - 1 && (a = RenderUtil.alpha(this.textureData[this.coord2(x + 1, y)])) < 64) {
            edge = true;
        }
        if (y > 0 && (a = RenderUtil.alpha(this.textureData[this.coord2(x, y - 1)])) < 64) {
            edge = true;
        }
        float mult = 0.5f;
        if (edge) {
            mult = 0.6f;
        }
        int r = (int)((float)RenderUtil.red(pixel) * mult);
        int g = (int)((float)RenderUtil.green(pixel) * mult);
        int b = (int)((float)RenderUtil.blue(pixel) * mult);
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return RenderUtil.compose(r, g, b, 255);
    }
}

