/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class HUDHandlerEntities
implements IWailaEntityProvider {
    static final IWailaEntityProvider INSTANCE = new HUDHandlerEntities();
    public static int nhearts = 20;
    public static float maxhpfortext = 40.0f;

    @Override
    @Nonnull
    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!Strings.isNullOrEmpty((String)FormattingConfig.entityFormat)) {
            try {
                currenttip.add("\u00a7r" + String.format(FormattingConfig.entityFormat, entity.func_70005_c_()));
            }
            catch (Exception e) {
                currenttip.add("\u00a7r" + String.format(FormattingConfig.entityFormat, "Unknown"));
            }
        } else {
            currenttip.add("Unknown");
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (config.getConfig("general.showhp") && entity instanceof EntityLivingBase) {
            nhearts = nhearts <= 0 ? 20 : nhearts;
            float health = ((EntityLivingBase)entity).func_110143_aJ() / 2.0f;
            float maxhp = ((EntityLivingBase)entity).func_110138_aP() / 2.0f;
            if (((EntityLivingBase)entity).func_110138_aP() > maxhpfortext) {
                currenttip.add(String.format(I18n.func_74838_a((String)"hud.msg.health") + ": %.0f / %.0f", Float.valueOf(((EntityLivingBase)entity).func_110143_aJ()), Float.valueOf(((EntityLivingBase)entity).func_110138_aP())));
            } else {
                currenttip.add(SpecialChars.getRenderString("waila.health", String.valueOf(nhearts), String.valueOf(health), String.valueOf(maxhp)));
            }
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        if (!Strings.isNullOrEmpty((String)FormattingConfig.modNameFormat) && !Strings.isNullOrEmpty((String)HUDHandlerEntities.getEntityMod(entity))) {
            currenttip.add(String.format(FormattingConfig.modNameFormat, HUDHandlerEntities.getEntityMod(entity)));
        }
        return currenttip;
    }

    private static String getEntityMod(Entity entity) {
        EntityEntry entityEntry = EntityRegistry.getEntry(entity.getClass());
        if (entityEntry == null) {
            return "Unknown";
        }
        ModContainer container = ModIdentification.findModContainer(entityEntry.getRegistryName().func_110624_b());
        return container.getName();
    }
}

